/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import com.jaspersoft.studio.editor.gef.parts.IPrefEditPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.JSSCompoundResizeTracker;
import com.jaspersoft.studio.editor.gef.parts.handles.CellResizeHandleLocator;
import com.jaspersoft.studio.editor.gef.parts.handles.CellResizeTracker;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.swt.SWTResourceManager;

public class CellResizeHandle
extends ResizeHandle {
    CellResizeTracker tracker = null;
    private int cursorDirection = 0;

    public CellResizeHandle(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        this.setLocator((Locator)new CellResizeHandleLocator(owner, direction));
        this.setPreferredSize(1, 1);
        this.cursorDirection = direction;
    }

    protected Color getBorderColor() {
        if (this.getOwner() instanceof IPrefEditPart) {
            return ((IPrefEditPart)this.getOwner()).getMarginColor();
        }
        return SWTResourceManager.getColor((RGB)IPrefEditPart.DEFAULT_MARGINCOLOR);
    }

    protected Color getFillColor() {
        if (this.getOwner().getFigure().getBounds().height == 0) {
            return ColorConstants.red;
        }
        return ColorConstants.blue;
    }

    protected DragTracker createDragTracker() {
        return new JSSCompoundResizeTracker(this.getOwner(), this.cursorDirection){

            protected List createOperationSet() {
                ArrayList<GraphicalEditPart> res = new ArrayList<GraphicalEditPart>();
                res.add(this.getOwner());
                return res;
            }

            @Override
            protected void showSourceFeedback() {
                Command command = this.getCurrentCommand();
                if (command != null && command.canExecute()) {
                    super.showSourceFeedback();
                }
            }
        };
    }
}

