/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;

public class CellResizeHandleLocator
extends RelativeLocator {
    private double relativeY;
    private double relativeX;
    private int direction;

    public CellResizeHandleLocator(GraphicalEditPart editPart, int location) {
        this.setReferenceFigure(editPart.getFigure());
        switch (location & 5) {
            case 1: {
                this.relativeY = 0.0;
                break;
            }
            case 4: {
                this.relativeY = 1.0;
                break;
            }
            default: {
                this.relativeY = 0.5;
            }
        }
        switch (location & 0x18) {
            case 8: {
                this.relativeX = 0.0;
                break;
            }
            case 16: {
                this.relativeX = 1.0;
                break;
            }
            default: {
                this.relativeX = 0.5;
            }
        }
        this.direction = location;
    }

    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        Rectangle referenceBox = null;
        referenceBox = reference instanceof HandleBounds ? ((HandleBounds)reference).getHandleBounds() : reference.getBounds();
        PrecisionRectangle targetBounds = new PrecisionRectangle(referenceBox.getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        targetBounds.resize(1, 1);
        int w = 2;
        int h = 2;
        switch (this.direction & 5) {
            case 1: {
                w = targetBounds.width;
                targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)(h / 2)) + 1;
                break;
            }
            case 4: {
                w = targetBounds.width;
                targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)(h / 2)) - 1;
                targetBounds.x += -1;
            }
        }
        switch (this.direction & 0x18) {
            case 8: {
                h = targetBounds.height;
                targetBounds.y += (int)this.relativeY - 1;
                targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)(w / 2)) - 1;
                break;
            }
            case 16: {
                h = targetBounds.height;
                targetBounds.y += (int)this.relativeY - 1;
                targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)(w / 2) - 1.0);
            }
        }
        targetBounds.setSize(w, h);
        target.setBounds((Rectangle)targetBounds);
    }
}

