/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.selection.ColoredSquareHandles;
import com.jaspersoft.studio.editor.gef.selection.GroupResizeTracker;
import com.jaspersoft.studio.editor.gef.selection.JSelectionManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.StructuredSelection;

public class GroupSelectionEditPart
extends AbstractGraphicalEditPart {
    public static final String BINDING_KEY_ID = "com.jaspersoft.studio.editor.groupselection";
    private List<ColoredSquareHandles> selectionHandles = null;
    private JSelectionManager selectionManager;
    private ZoomManager zoomManager;

    public GroupSelectionEditPart(JSelectionManager selectionManager, ZoomManager zoomManager) {
        this.selectionManager = selectionManager;
        this.zoomManager = zoomManager;
        this.createEditPolicies();
    }

    protected IFigure createFigure() {
        return new GroupSelectionFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableEditPolicy(){

            protected IFigure getFeedbackLayer() {
                StructuredSelection sel = (StructuredSelection)GroupSelectionEditPart.this.selectionManager.getSelection();
                IFigure layer = LayerManager.Helper.find((EditPart)((EditPart)sel.getFirstElement())).getLayer((Object)"Handle Layer");
                return layer;
            }

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
                if (Util.isLinux()) {
                    GroupSelectionEditPart.this.selectionManager.getViewer().getControl().redraw();
                }
            }

            protected Command getResizeCommand(final ChangeBoundsRequest request) {
                return new Command(){
                    private int oldWidth;
                    private int oldHeight;

                    public void execute() {
                        if (GroupSelectionEditPart.this.figure != null) {
                            PrecisionRectangle rect = new PrecisionRectangle(GroupSelectionEditPart.this.figure.getBounds().getCopy());
                            this.oldWidth = ((GroupSelectionEditPart)(this).GroupSelectionEditPart.this).figure.getBounds().width;
                            this.oldHeight = ((GroupSelectionEditPart)(this).GroupSelectionEditPart.this).figure.getBounds().height;
                            rect.translate(request.getMoveDelta());
                            rect.resize(request.getSizeDelta());
                            GroupSelectionEditPart.this.figure.setBounds((Rectangle)rect);
                        }
                    }

                    public void undo() {
                        if (GroupSelectionEditPart.this.figure != null) {
                            PrecisionRectangle rect = new PrecisionRectangle(GroupSelectionEditPart.this.figure.getBounds().getCopy());
                            rect.setWidth(this.oldWidth);
                            rect.setHeight(this.oldHeight);
                            GroupSelectionEditPart.this.figure.setBounds((Rectangle)rect);
                        }
                    }
                };
            }
        });
    }

    public void clear() {
        ((GroupSelectionFigure)this.getFigure()).clear();
        this.removeSelectionHandles();
    }

    public boolean isActive() {
        return this.figure != null && this.figure.getParent() != null;
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new GroupResizeTracker(this, direction);
    }

    protected void removeSelectionHandles() {
        if (this.selectionHandles == null) {
            return;
        }
        for (ColoredSquareHandles handle : this.selectionHandles) {
            IFigure parent = handle.getParent();
            if (parent == null || !parent.getChildren().contains((Object)handle)) continue;
            parent.remove((IFigure)handle);
        }
        this.selectionHandles = null;
    }

    public void createSelectionHandles(IFigure parent) {
        this.removeSelectionHandles();
        this.selectionHandles = new ArrayList<ColoredSquareHandles>();
        this.createResizeHandle(this.selectionHandles, 1);
        this.createResizeHandle(this.selectionHandles, 16);
        this.createResizeHandle(this.selectionHandles, 4);
        this.createResizeHandle(this.selectionHandles, 8);
        this.createResizeHandle(this.selectionHandles, 20);
        this.createResizeHandle(this.selectionHandles, 12);
        this.createResizeHandle(this.selectionHandles, 9);
        this.createResizeHandle(this.selectionHandles, 17);
        for (ColoredSquareHandles handle : this.selectionHandles) {
            parent.add((IFigure)handle);
        }
    }

    protected void createResizeHandle(List<ColoredSquareHandles> handles, int direction) {
        ColoredSquareHandles handle = new ColoredSquareHandles((GraphicalEditPart)this, direction){

            @Override
            protected Color[] getFillColorAwt() {
                return JSS_FOCUSED_COLOR;
            }
        };
        handle.setDragTracker((DragTracker)this.getResizeTracker(direction));
        handle.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)this.getFigure().isMirrored()));
        handles.add(handle);
    }

    protected JSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void updateBounds(boolean createFigure) {
        if (this.isActive() || createFigure) {
            this.getFigure().setBounds(this.calculateBounds());
        }
    }

    protected Rectangle calculateBounds() {
        StructuredSelection selection = (StructuredSelection)this.selectionManager.getSelection();
        if (selection != null && !selection.isEmpty()) {
            List listSelection = selection.toList();
            Integer x = null;
            Integer y = null;
            Integer xe = null;
            Integer ye = null;
            boolean partFound = false;
            for (Object part : listSelection) {
                if (!(part instanceof FigureEditPart)) continue;
                partFound = true;
                FigureEditPart figure = (FigureEditPart)part;
                Rectangle bounds = figure.getFigure().getBounds();
                if (x == null || bounds.x < x) {
                    x = bounds.x;
                }
                if (y == null || bounds.y < y) {
                    y = bounds.y;
                }
                if (xe == null || bounds.x + bounds.width > xe) {
                    xe = bounds.x + bounds.width - 1;
                }
                if (ye != null && bounds.y + bounds.height <= ye) continue;
                ye = bounds.y + bounds.height - 1;
            }
            if (partFound) {
                double zoomFactor = this.zoomManager.getZoom();
                x = (int)Math.round((double)x.intValue() * zoomFactor);
                y = (int)Math.round((double)y.intValue() * zoomFactor);
                xe = (int)Math.round((double)xe.intValue() * zoomFactor);
                ye = (int)Math.round((double)ye.intValue() * zoomFactor);
                return new Rectangle(x.intValue(), y.intValue(), xe - x, ye - y);
            }
        }
        return new Rectangle();
    }

    private class GroupSelectionFigure
    extends RectangleFigure {
        public GroupSelectionFigure() {
            this.setFill(false);
        }

        public void clear() {
            if (this.getParent() != null && this.getParent().getChildren().contains((Object)this)) {
                this.getParent().remove((IFigure)this);
            }
        }

        public void validate() {
            GroupSelectionEditPart.this.updateBounds(false);
        }
    }
}

