/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.gef.selection.GroupSelectionEditPart;
import com.jaspersoft.studio.editor.java2d.J2DScrollingGraphicalViewer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.IKeyboardEvent;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JSelectionManager
extends SelectionManager {
    private static EditPart lastSelected = null;
    private List<Object> selection;
    private GroupSelectionEditPart selectionPart;
    private boolean isGroupButtonPressed = false;
    private IKeyboardEvent keyboardEvent = new IKeyboardEvent(){

        public void keyUp(int keycode) {
            if (JSelectionManager.this.getGroupSelectionPart().isActive() && !BindingsPreferencePersistence.isPressed("com.jaspersoft.studio.editor.groupselection")) {
                JSelectionManager.this.isGroupButtonPressed = false;
                JSelectionManager.this.setSelection((ISelection)new StructuredSelection(JSelectionManager.this.selection));
            }
        }

        public void keyDown(int keycode) {
            if (!JSelectionManager.this.isGroupButtonPressed && BindingsPreferencePersistence.isPressed("com.jaspersoft.studio.editor.groupselection")) {
                JSelectionManager.this.isGroupButtonPressed = true;
                JSelectionManager.this.setSelection((ISelection)new StructuredSelection(JSelectionManager.this.selection));
            }
        }
    };

    public void internalInitialize(EditPartViewer viewer, List selection, Runnable notifier) {
        super.internalInitialize(viewer, selection, notifier);
        this.selection = selection;
        JasperReportsPlugin.addKeyListener((IKeyboardEvent)this.keyboardEvent);
    }

    private boolean isRefreshIgnored(List<?> selection) {
        for (Object item : selection) {
            ANode mainNode;
            EditPart part;
            if (!(item instanceof EditPart) || !((part = (EditPart)item).getModel() instanceof ANode) || (mainNode = JSSCompoundCommand.getMainNode((ANode)part.getModel())) == null) continue;
            return JSSCompoundCommand.isRefreshEventsIgnored(mainNode);
        }
        return false;
    }

    public void deselect(EditPart editpart) {
        if (!JSSCompoundCommand.isRefreshEventsIgnored((ANode)editpart.getModel())) {
            super.deselect(editpart);
        }
    }

    private IStructuredSelection removeUnselectableParts(List<?> orderedSelection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (Object obj : orderedSelection) {
            EditPart part = (EditPart)obj;
            if (!part.isSelectable()) continue;
            result.add(part);
        }
        return new StructuredSelection(result);
    }

    protected GroupSelectionEditPart getGroupSelectionPart() {
        if (this.selectionPart == null) {
            ZoomManager zoomManager = (ZoomManager)this.getViewer().getProperty(ZoomManager.class.toString());
            this.selectionPart = new GroupSelectionEditPart(this, zoomManager);
        }
        return this.selectionPart;
    }

    public void setGroupSelection(ISelection newSelection) {
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List orderedSelection = ((IStructuredSelection)newSelection).toList();
        this.getViewer().setFocus(null);
        ArrayList clearedSelection = new ArrayList();
        for (Object selectedElement : orderedSelection) {
            if (selectedElement instanceof BandEditPart) continue;
            clearedSelection.add(selectedElement);
        }
        this.selection.clear();
        this.selection.addAll(clearedSelection);
        if (!clearedSelection.isEmpty()) {
            EditPart firstPart = (EditPart)clearedSelection.get(0);
            IFigure layer = LayerManager.Helper.find((EditPart)firstPart).getLayer((Object)"Handle Layer");
            this.getGroupSelectionPart().updateBounds(true);
            layer.add(this.getGroupSelectionPart().getFigure());
            this.getGroupSelectionPart().createSelectionHandles(layer);
        }
        this.fireSelectionChanged();
    }

    public void eraseFeedback(List<?> selection) {
        this.getViewer().setFocus(null);
        int i = 0;
        while (i < selection.size()) {
            EditPart part = (EditPart)selection.get(i);
            part.setSelected(0);
            ++i;
        }
    }

    public void appendSelection(EditPart editpart) {
        this.getGroupSelectionPart().clear();
        if (BindingsPreferencePersistence.isPressed("com.jaspersoft.studio.editor.groupselection")) {
            IStructuredSelection newSelection;
            ArrayList<Object> newSelectionList = new ArrayList<Object>(this.selection);
            if (!newSelectionList.contains(editpart)) {
                newSelectionList.add(editpart);
            }
            if ((newSelection = this.removeUnselectableParts(newSelectionList)).size() > 1) {
                this.eraseFeedback(this.selection);
                this.setGroupSelection((ISelection)newSelection);
                return;
            }
        }
        super.appendSelection(editpart);
    }

    public void deselectAll() {
        this.getGroupSelectionPart().clear();
        super.deselectAll();
    }

    public EditPartViewer getViewer() {
        return super.getViewer();
    }

    protected boolean isGroupSelection(IStructuredSelection selection) {
        return BindingsPreferencePersistence.isPressed("com.jaspersoft.studio.editor.groupselection") && selection.size() > 1;
    }

    public void setSelection(ISelection newSelection) {
        this.getGroupSelectionPart().clear();
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List orderedSelection = ((IStructuredSelection)newSelection).toList();
        if (this.isRefreshIgnored(orderedSelection)) {
            return;
        }
        EditPart focusedEditPart = null;
        if (!orderedSelection.isEmpty()) {
            Iterator itr = orderedSelection.iterator();
            EditPart part2 = (EditPart)itr.next();
            if (part2.getViewer() != null) {
                IStructuredSelection cleanSelection;
                focusedEditPart = part2.getViewer().getFocusEditPart();
                if (!(focusedEditPart instanceof BandEditPart) && focusedEditPart instanceof FigureEditPart) {
                    lastSelected = focusedEditPart;
                }
                if (lastSelected != null && !orderedSelection.contains(lastSelected)) {
                    lastSelected = null;
                }
                if (this.isGroupSelection(cleanSelection = this.removeUnselectableParts(orderedSelection))) {
                    this.eraseFeedback(orderedSelection);
                    this.setGroupSelection((ISelection)cleanSelection);
                    if (lastSelected == null) {
                        lastSelected = (EditPart)orderedSelection.get(0);
                    }
                    return;
                }
                super.setSelection((ISelection)cleanSelection);
                if (lastSelected == null) {
                    lastSelected = (EditPart)orderedSelection.get(0);
                }
                if (lastSelected.isSelectable()) {
                    lastSelected.setSelected(2);
                }
                for (EditPart part2 : orderedSelection) {
                    if (!part2.isSelectable() || part2 == lastSelected) continue;
                    part2.setSelected(1);
                }
            }
        } else {
            super.deselectAll();
        }
    }

    public ISelection getSelection() {
        if (this.selection.isEmpty() && this.getViewer() instanceof J2DScrollingGraphicalViewer) {
            return StructuredSelection.EMPTY;
        }
        return super.getSelection();
    }
}

