/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.gef.figures.ACachedGraphics;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class ImageGraphics2D
extends ACachedGraphics {
    private BufferedImage image;
    private Graphics2D imageGraphics;
    private Graphics2D targetGraphics;

    public ImageGraphics2D(Graphics2D originalGrpahics) {
        this.targetGraphics = originalGrpahics;
        double scaleX = originalGrpahics.getTransform().getScaleX();
        double scaleY = originalGrpahics.getTransform().getScaleY();
        this.image = new BufferedImage((int)((double)this.targetGraphics.getClipBounds().width * Math.max(1.0, scaleX)), (int)((double)originalGrpahics.getClipBounds().height * Math.max(1.0, scaleY)), 2);
        this.image.getWidth();
        this.image.getHeight();
        this.imageGraphics = this.image.createGraphics();
        this.imageGraphics.scale(scaleX, scaleY);
        this.imageGraphics.setRenderingHints(originalGrpahics.getRenderingHints());
        this.imageGraphics.setClip(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()));
    }

    public ImageGraphics2D(Graphics2D originalGrpahics, int width, int height) {
        this.targetGraphics = originalGrpahics;
        this.image = new BufferedImage(width, height, 2);
        this.imageGraphics = this.image.createGraphics();
        double scaleX = originalGrpahics.getTransform().getScaleX();
        double scaleY = originalGrpahics.getTransform().getScaleY();
        this.imageGraphics.scale(scaleX, scaleY);
        this.imageGraphics.setClip(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()));
    }

    @Override
    public void paintCache() {
        double scaleX = this.targetGraphics.getTransform().getScaleX();
        double scaleY = this.targetGraphics.getTransform().getScaleY();
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        AffineTransform transform = new AffineTransform();
        transform.scale(1.0 / scaleX, 1.0 / scaleY);
        this.targetGraphics.drawImage(this.image, transform, null);
    }

    @Override
    public void setGraphics(Graphics2D graphics) {
        this.targetGraphics = graphics;
    }

    @Override
    public void draw(Shape s) {
        this.imageGraphics.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.imageGraphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.imageGraphics.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.imageGraphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.imageGraphics.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.imageGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.imageGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.imageGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.imageGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.imageGraphics.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.imageGraphics.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.imageGraphics.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.imageGraphics.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.imageGraphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.imageGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.imageGraphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.imageGraphics.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.imageGraphics.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.imageGraphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.imageGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.imageGraphics.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.imageGraphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.imageGraphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.imageGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.imageGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.imageGraphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.imageGraphics.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.imageGraphics.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.imageGraphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.imageGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.imageGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.imageGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.imageGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.imageGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.imageGraphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.imageGraphics.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.imageGraphics.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return this.imageGraphics.create();
    }

    @Override
    public Color getColor() {
        return this.imageGraphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.imageGraphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.imageGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.imageGraphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.imageGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.imageGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.imageGraphics.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.imageGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.imageGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.imageGraphics.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.imageGraphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.imageGraphics.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.imageGraphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.imageGraphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.imageGraphics.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.imageGraphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.imageGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.imageGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.imageGraphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.imageGraphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.imageGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.imageGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.imageGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.imageGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        this.imageGraphics.dispose();
    }
}

