/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.gef.figures.ACachedGraphics;
import com.jaspersoft.studio.editor.java2d.StaticCallResolver;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackGraphics2D
extends ACachedGraphics {
    private Graphics2D realDrawer;
    private HashMap<Object, BackupProperty> statusRestorer = new HashMap();
    private List<ExecutableCommand> stack = new ArrayList<ExecutableCommand>();
    private List<StackGraphics2D> subGraphics = new ArrayList<StackGraphics2D>();

    public StackGraphics2D(Graphics2D realDrawer) {
        this.realDrawer = realDrawer;
    }

    @Override
    public void setGraphics(Graphics2D graphics) {
        this.realDrawer = graphics;
    }

    @Override
    public void paintCache() {
        for (ExecutableCommand definition : this.stack) {
            definition.execute();
        }
        for (StackGraphics2D subGraphic : this.subGraphics) {
            subGraphic.paintCache();
        }
        double scaleX = this.realDrawer.getTransform().getScaleX();
        double scaleY = this.realDrawer.getTransform().getScaleY();
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void clearStack() {
        this.stack.clear();
    }

    private AffineTransform copyTransform(AffineTransform original) {
        return new AffineTransform(original);
    }

    @Override
    public void addRenderingHints(Map<?, ?> arg0) {
        StaticCallDefinition call = new StaticCallDefinition(0, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setRenderingHints(Map<?, ?> arg0) {
        StaticCallDefinition call = new StaticCallDefinition(1, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void clip(Shape arg0) {
        StaticCallDefinition call = new StaticCallDefinition(2, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void draw(Shape arg0) {
        StaticCallDefinition call = new StaticCallDefinition(3, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void drawGlyphVector(GlyphVector arg0, float arg1, float arg2) {
        StaticCallDefinition call = new StaticCallDefinition(4, 3);
        call.addValue(arg0);
        call.addValue(Float.valueOf(arg1));
        call.addValue(Float.valueOf(arg2));
        this.stack.add(call);
    }

    @Override
    public boolean drawImage(Image arg0, AffineTransform arg1, ImageObserver arg2) {
        StaticCallDefinition call = new StaticCallDefinition(5, 3);
        call.addValue(arg0);
        call.addValue(this.copyTransform(arg1));
        call.addValue(arg2);
        this.stack.add(call);
        return false;
    }

    @Override
    public void drawImage(BufferedImage arg0, BufferedImageOp arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(6, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void drawRenderableImage(RenderableImage arg0, AffineTransform arg1) {
        StaticCallDefinition call = new StaticCallDefinition(7, 2);
        call.addValue(arg0);
        call.addValue(this.copyTransform(arg1));
        this.stack.add(call);
    }

    @Override
    public void drawRenderedImage(RenderedImage arg0, AffineTransform arg1) {
        StaticCallDefinition call = new StaticCallDefinition(8, 2);
        call.addValue(arg0);
        call.addValue(this.copyTransform(arg1));
        this.stack.add(call);
    }

    @Override
    public void drawString(String arg0, int arg1, int arg2) {
        StaticCallDefinition call = new StaticCallDefinition(9, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void drawString(String arg0, float arg1, float arg2) {
        StaticCallDefinition call = new StaticCallDefinition(10, 3);
        call.addValue(arg0);
        call.addValue(Float.valueOf(arg1));
        call.addValue(Float.valueOf(arg2));
        this.stack.add(call);
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, int arg1, int arg2) {
        StaticCallDefinition call = new StaticCallDefinition(11, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void drawString(AttributedCharacterIterator arg0, float arg1, float arg2) {
        StaticCallDefinition call = new StaticCallDefinition(12, 3);
        call.addValue(arg0);
        call.addValue(Float.valueOf(arg1));
        call.addValue(Float.valueOf(arg2));
        this.stack.add(call);
    }

    @Override
    public void fill(Shape arg0) {
        StaticCallDefinition call = new StaticCallDefinition(13, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public boolean hit(Rectangle arg0, Shape arg1, boolean arg2) {
        StaticCallDefinition call = new StaticCallDefinition(14, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
        return false;
    }

    @Override
    public void rotate(double arg0) {
        StaticCallDefinition call = new StaticCallDefinition(15, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void rotate(double arg0, double arg1, double arg2) {
        StaticCallDefinition call = new StaticCallDefinition(16, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void scale(double arg0, double arg1) {
        StaticCallDefinition call = new StaticCallDefinition(17, 2);
        call.addValue(arg0);
        call.addValue(arg1);
        this.stack.add(call);
    }

    @Override
    public void setBackground(Color arg0) {
        StaticCallDefinition call = new StaticCallDefinition(18, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setComposite(Composite arg0) {
        StaticCallDefinition call = new StaticCallDefinition(19, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setPaint(Paint arg0) {
        StaticCallDefinition call = new StaticCallDefinition(20, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        StaticCallDefinition call = new StaticCallDefinition(21, 2);
        call.addValue(arg0);
        call.addValue(arg1);
        this.stack.add(call);
    }

    @Override
    public void setStroke(Stroke arg0) {
        StaticCallDefinition call = new StaticCallDefinition(22, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setTransform(AffineTransform arg0) {
        if (!this.statusRestorer.containsKey(arg0)) {
            StaticCallDefinition call = new StaticCallDefinition(23, 1);
            call.addValue(this.copyTransform(arg0));
            this.stack.add(call);
        } else {
            BackupProperty backup = this.statusRestorer.get(arg0);
            RestoreProperty call = new RestoreProperty("setTransform", backup);
            this.stack.add(call);
        }
    }

    @Override
    public void shear(double arg0, double arg1) {
        StaticCallDefinition call = new StaticCallDefinition(24, 2);
        call.addValue(arg0);
        call.addValue(arg1);
        this.stack.add(call);
    }

    @Override
    public void transform(AffineTransform arg0) {
        StaticCallDefinition call = new StaticCallDefinition(25, 1);
        call.addValue(this.copyTransform(arg0));
        this.stack.add(call);
    }

    @Override
    public void translate(int arg0, int arg1) {
        StaticCallDefinition call = new StaticCallDefinition(26, 2);
        call.addValue(arg0);
        call.addValue(arg1);
        this.stack.add(call);
    }

    @Override
    public void translate(double arg0, double arg1) {
        StaticCallDefinition call = new StaticCallDefinition(27, 2);
        call.addValue(arg0);
        call.addValue(arg1);
        this.stack.add(call);
    }

    @Override
    public void clearRect(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(28, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void clipRect(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(29, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void copyArea(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        StaticCallDefinition call = new StaticCallDefinition(30, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
    }

    @Override
    public void drawArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        StaticCallDefinition call = new StaticCallDefinition(31, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, ImageObserver arg3) {
        StaticCallDefinition call = new StaticCallDefinition(32, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, Color arg3, ImageObserver arg4) {
        StaticCallDefinition call = new StaticCallDefinition(33, 5);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        this.stack.add(call);
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, ImageObserver arg5) {
        StaticCallDefinition call = new StaticCallDefinition(34, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, Color arg5, ImageObserver arg6) {
        StaticCallDefinition call = new StaticCallDefinition(35, 7);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        call.addValue(arg6);
        this.stack.add(call);
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, ImageObserver arg9) {
        StaticCallDefinition call = new StaticCallDefinition(36, 10);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        call.addValue(arg6);
        call.addValue(arg7);
        call.addValue(arg8);
        call.addValue(arg9);
        this.stack.add(call);
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Color arg9, ImageObserver arg10) {
        StaticCallDefinition call = new StaticCallDefinition(37, 11);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        call.addValue(arg6);
        call.addValue(arg7);
        call.addValue(arg8);
        call.addValue(arg9);
        call.addValue(arg10);
        this.stack.add(call);
        return false;
    }

    @Override
    public void drawLine(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(38, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void drawOval(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(39, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void drawPolygon(int[] arg0, int[] arg1, int arg2) {
        StaticCallDefinition call = new StaticCallDefinition(40, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void drawPolyline(int[] arg0, int[] arg1, int arg2) {
        StaticCallDefinition call = new StaticCallDefinition(41, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void drawRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        StaticCallDefinition call = new StaticCallDefinition(42, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
    }

    @Override
    public void fillArc(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        StaticCallDefinition call = new StaticCallDefinition(43, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
    }

    @Override
    public void fillOval(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(44, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void fillPolygon(int[] arg0, int[] arg1, int arg2) {
        StaticCallDefinition call = new StaticCallDefinition(45, 3);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        this.stack.add(call);
    }

    @Override
    public void fillRect(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(46, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void fillRoundRect(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        StaticCallDefinition call = new StaticCallDefinition(47, 6);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        call.addValue(arg4);
        call.addValue(arg5);
        this.stack.add(call);
    }

    @Override
    public void setClip(Shape arg0) {
        if (!this.statusRestorer.containsKey(arg0)) {
            StaticCallDefinition call = new StaticCallDefinition(48, 1);
            call.addValue(arg0);
            this.stack.add(call);
        } else {
            BackupProperty backup = this.statusRestorer.get(arg0);
            RestoreProperty call = new RestoreProperty("setClip", backup);
            this.stack.add(call);
        }
    }

    @Override
    public void setClip(int arg0, int arg1, int arg2, int arg3) {
        StaticCallDefinition call = new StaticCallDefinition(49, 4);
        call.addValue(arg0);
        call.addValue(arg1);
        call.addValue(arg2);
        call.addValue(arg3);
        this.stack.add(call);
    }

    @Override
    public void setColor(Color arg0) {
        StaticCallDefinition call = new StaticCallDefinition(50, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setFont(Font arg0) {
        StaticCallDefinition call = new StaticCallDefinition(51, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public void setPaintMode() {
        StaticCallDefinition call = new StaticCallDefinition(52, 0);
        this.stack.add(call);
    }

    @Override
    public void setXORMode(Color arg0) {
        StaticCallDefinition call = new StaticCallDefinition(53, 1);
        call.addValue(arg0);
        this.stack.add(call);
    }

    @Override
    public Color getBackground() {
        return this.realDrawer.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.realDrawer.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.realDrawer.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.realDrawer.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.realDrawer.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.realDrawer.getRenderingHint(arg0);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.realDrawer.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.realDrawer.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        BackupProperty backupCommand = new BackupProperty("getTransform");
        this.stack.add(backupCommand);
        AffineTransform bindingReference = this.realDrawer.getTransform();
        this.statusRestorer.put(bindingReference, backupCommand);
        return bindingReference;
    }

    @Override
    public Shape getClip() {
        BackupProperty backupCommand = new BackupProperty("getClip");
        this.stack.add(backupCommand);
        Shape bindingReference = this.realDrawer.getClip();
        this.statusRestorer.put(bindingReference, backupCommand);
        return bindingReference;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.realDrawer.getClipBounds();
    }

    @Override
    public Color getColor() {
        return this.realDrawer.getColor();
    }

    @Override
    public Font getFont() {
        return this.realDrawer.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font arg0) {
        return this.realDrawer.getFontMetrics(arg0);
    }

    @Override
    public Graphics create() {
        StackGraphics2D subGraphic = new StackGraphics2D((Graphics2D)this.realDrawer.create());
        this.subGraphics.add(subGraphic);
        return subGraphic;
    }

    @Override
    public void dispose() {
        this.realDrawer.dispose();
    }

    private class BackupProperty
    implements ExecutableCommand {
        private String propertyName;
        private Object propertyValue;
        private Class<?> returnType;

        public BackupProperty(String propertyName) {
            this.propertyName = propertyName;
            this.propertyValue = null;
        }

        public Object getReturnValue() {
            return this.propertyValue;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        @Override
        public void execute() {
            try {
                Method method = StackGraphics2D.this.realDrawer.getClass().getMethod(this.propertyName, new Class[0]);
                this.returnType = method.getReturnType();
                this.propertyValue = method.invoke((Object)StackGraphics2D.this.realDrawer, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class CallDefinition
    implements ExecutableCommand {
        private List<Class<?>> parametersType = new ArrayList();
        private List<Object> parametersValue = new ArrayList<Object>();
        private String methodName;

        public CallDefinition(String name) {
            this.methodName = name;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void addType(Class<?> newType) {
            this.parametersType.add(newType);
        }

        public void addValue(Object newValue) {
            this.parametersValue.add(newValue);
        }

        public Object[] getValues() {
            return this.parametersValue.toArray(new Object[this.parametersValue.size()]);
        }

        public Class<?>[] getTypes() {
            return this.parametersType.toArray(new Class[this.parametersType.size()]);
        }

        @Override
        public void execute() {
            try {
                Method method = Graphics2D.class.getMethod(this.getMethodName(), this.getTypes());
                method.invoke((Object)StackGraphics2D.this.realDrawer, this.getValues());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static interface ExecutableCommand {
        public void execute();
    }

    private class RestoreProperty
    implements ExecutableCommand {
        private String propertyName;
        private BackupProperty propertyInfo;

        public RestoreProperty(String propertyName, BackupProperty propertyInfo) {
            this.propertyName = propertyName;
            this.propertyInfo = propertyInfo;
        }

        @Override
        public void execute() {
            try {
                Method method = StackGraphics2D.this.realDrawer.getClass().getMethod(this.propertyName, this.propertyInfo.getReturnType());
                method.invoke((Object)StackGraphics2D.this.realDrawer, this.propertyInfo.getReturnValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class StaticCallDefinition
    implements ExecutableCommand {
        private int methodId;
        private Object[] parametersValue;
        private int actualAddedParameters = 0;

        public StaticCallDefinition(int methodId, int parametersNumber) {
            this.methodId = methodId;
            this.parametersValue = new Object[parametersNumber];
        }

        public void addValue(Object newValue) {
            this.parametersValue[this.actualAddedParameters] = newValue;
            ++this.actualAddedParameters;
        }

        @Override
        public void execute() {
            StaticCallResolver.resolveCall(this.methodId, this.parametersValue, StackGraphics2D.this.realDrawer);
        }
    }
}

