/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout.spreadsheet;

import com.jaspersoft.studio.editor.layout.AbstractLayout;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayoutUIProvider;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.spreadsheet.SpreadSheetElementsCache;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SpreadsheetLayout
extends AbstractLayout {
    private static HashMap<JasperDesign, SpreadSheetElementsCache> cache = new HashMap();
    public static final String PROPERTY_ID = "com.jaspersoft.studio.spreadsheet.connectionID";

    private MBand getParentBand(ANode element) {
        ANode parent = element;
        while (parent != null) {
            if (parent instanceof MBand) {
                return (MBand)parent;
            }
            parent = parent instanceof MPage ? ((MPage)parent).getRealParent() : parent.getParent();
        }
        return null;
    }

    @Override
    public Map<JRElement, Rectangle> layout(JasperDesign jd, JRElementGroup container, JRElement[] elements, Dimension c) {
        MBand ancestorBand = this.getParentBand(SelectionHelper.getNode(container));
        if (ancestorBand != null && ancestorBand.getBandType() != BandTypeEnum.DETAIL && jd.getDetailSection().getBands().length > 0) {
            JRBand firstDetail = jd.getDetailSection().getBands()[0];
            List<JRDesignElement> detailElements = ModelUtils.getGElements((JRElementGroup)firstDetail);
            HashMap<String, JRDesignElement> detailElementsMap = new HashMap<String, JRDesignElement>();
            firstDetail.getPropertiesMap().removeProperty("com.jaspersoft.studio.layout");
            for (JRDesignElement detailElement : detailElements) {
                String uuidProp = detailElement.getPropertiesMap().getProperty(PROPERTY_ID);
                if (uuidProp == null) continue;
                detailElementsMap.put(uuidProp, detailElement);
            }
            JRElement[] jRElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                JRDesignElement detailElement;
                JRElement el = jRElementArray[n2];
                String currentElementUUid = el.getPropertiesMap().getProperty(PROPERTY_ID);
                if (currentElementUUid != null && (detailElement = (JRDesignElement)detailElementsMap.get(currentElementUUid)) != null) {
                    detailElement.setWidth(el.getWidth());
                }
                ++n2;
            }
            firstDetail.getPropertiesMap().setProperty("com.jaspersoft.studio.layout", SpreadsheetLayout.class.getName());
            return this.layoutDetail(jd, (JRElementGroup)firstDetail, firstDetail.getElements(), new Dimension(jd.getPageWidth(), firstDetail.getHeight()));
        }
        return this.layoutDetail(jd, container, elements, c);
    }

    private Map<JRElement, Rectangle> layoutDetail(JasperDesign jd, JRElementGroup container, JRElement[] elements, Dimension c) {
        HashMap<JRElement, Rectangle> map = new HashMap<JRElement, Rectangle>();
        int x = 0;
        int h = c.height;
        JRElement[] jRElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String elementUUID;
            List<JRDesignElement> connectedElements;
            JRElement el = jRElementArray[n2];
            JRDesignElement del = (JRDesignElement)el;
            map.put(el, new Rectangle(el.getX(), el.getY(), el.getWidth(), el.getHeight()));
            del.setX(x);
            del.setY(0);
            x += del.getWidth();
            del.setWidth(del.getWidth());
            del.setHeight(h);
            LayoutManager.layout(jd, map, el);
            int absoluteX = el.getX();
            ANode elNode = SelectionHelper.getNode(el);
            if (elNode != null) {
                ANode elParent = elNode.getParent();
                while (elParent != null) {
                    if (elParent.getValue() instanceof JRDesignElement) {
                        JRDesignElement elJRParent = (JRDesignElement)elParent.getValue();
                        absoluteX += elJRParent.getX();
                    }
                    elParent = elParent.getParent();
                }
            }
            if ((connectedElements = this.getElementForUUID(elementUUID = del.getPropertiesMap().getProperty(PROPERTY_ID), jd, el)) != null) {
                for (JRDesignElement connectedElement : connectedElements) {
                    JRPropertiesMap connectedContainerMap;
                    if (connectedElement == el) continue;
                    JRElementGroup connectedContainer = (JRElementGroup)SelectionHelper.getNode(connectedElement).getParent().getValue();
                    String oldConnectedContainerLayout = null;
                    if (connectedContainer != null) {
                        connectedContainerMap = ((JRPropertiesHolder)connectedContainer).getPropertiesMap();
                        oldConnectedContainerLayout = connectedContainerMap.getProperty("com.jaspersoft.studio.layout");
                        if (!SpreadsheetLayout.class.getName().equals(oldConnectedContainerLayout)) continue;
                        connectedContainerMap.setProperty("com.jaspersoft.studio.layout", FreeLayout.class.getName());
                    }
                    map.put((JRElement)connectedElement, new Rectangle(connectedElement.getX(), connectedElement.getY(), connectedElement.getWidth(), connectedElement.getHeight()));
                    connectedElement.setX(absoluteX);
                    connectedElement.setWidth(del.getWidth());
                    connectedElement.setY(0);
                    if (connectedContainer instanceof JRBand) {
                        connectedElement.setHeight(((JRBand)connectedContainer).getHeight());
                    } else if (connectedContainer instanceof JRElement) {
                        connectedElement.setHeight(((JRElement)connectedContainer).getHeight());
                    }
                    LayoutManager.layout(jd, map, (JRElement)connectedElement);
                    if (connectedContainer == null) continue;
                    connectedContainerMap = ((JRPropertiesHolder)connectedContainer).getPropertiesMap();
                    connectedContainerMap.setProperty("com.jaspersoft.studio.layout", oldConnectedContainerLayout);
                }
            }
            ++n2;
        }
        return map;
    }

    @Override
    public String getName() {
        return "Spreadsheet Layout";
    }

    @Override
    public String getToolTip() {
        return "SpreadSheet Layout";
    }

    @Override
    public String getIcon() {
        return "icons/layout-3.png";
    }

    @Override
    public boolean showAdditionalControlsOnNode(JRPropertiesMap elementProperties, JRPropertiesMap parentProperties) {
        return false;
    }

    @Override
    public ILayoutUIProvider getControlsProvider() {
        return null;
    }

    private boolean isParentFirstDetailBand(ANode node) {
        JRBand[] detailBands;
        ANode parent;
        return node != null && (parent = node.getParent()) != null && parent instanceof MBand && (detailBands = node.getJasperDesign().getDetailSection().getBands()).length > 0 && detailBands[0] == parent.getValue();
    }

    @Override
    public boolean allowChildBoundChange(ANode resizedNode, Rectangle oldBounds, Rectangle newBounds) {
        if (oldBounds == null || newBounds == null) {
            return false;
        }
        if (ModelUtils.safeEquals(oldBounds, newBounds)) {
            return true;
        }
        if (this.isParentFirstDetailBand(resizedNode)) {
            return oldBounds.width != newBounds.width || oldBounds.height != newBounds.height;
        }
        JRPropertiesMap nodeMap = LayoutManager.getPropertyHolder(resizedNode).getPropertiesMap();
        if (!nodeMap.containsProperty(PROPERTY_ID)) {
            return true;
        }
        return oldBounds.width != newBounds.width || oldBounds.height != newBounds.height;
    }

    @Override
    public Map<Object, Rectangle> getLayoutPosition(Object[] elements, int insertPosition, Dimension parentSize) {
        HashMap<Object, Rectangle> map = new HashMap<Object, Rectangle>();
        int x = 0;
        int h = parentSize.height;
        ArrayList<JRElement> jrElements = new ArrayList<JRElement>();
        ArrayList<JRField> jrFields = new ArrayList<JRField>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof JRElement) {
                jrElements.add((JRElement)el);
            } else if (el instanceof JRField) {
                jrFields.add((JRField)el);
            }
            ++n2;
        }
        if (jrFields.isEmpty()) {
            for (JRElement jrEl : jrElements) {
                map.put(jrEl, new Rectangle(x, 0, jrEl.getWidth(), h));
                x += jrEl.getWidth();
            }
        } else if (insertPosition >= 0) {
            int i = 0;
            while (i < insertPosition) {
                Object el = elements[i];
                if (el instanceof JRElement) {
                    x += ((JRElement)el).getWidth();
                }
                ++i;
            }
            map.put(jrFields.get(0), new Rectangle(x - 2, 0, 4, h));
        }
        return map;
    }

    private List<JRDesignElement> getElementForUUID(String uuid, JasperDesign jd, JRElement element) {
        SpreadSheetElementsCache jdCache = cache.get(jd);
        if (jdCache == null) {
            MReport report = ModelUtils.getReport(SelectionHelper.getNode(element));
            jdCache = new SpreadSheetElementsCache(jd, report);
            cache.put(jd, jdCache);
        }
        return jdCache.getElementsFor(uuid);
    }

    public static List<JRDesignElement> getElementsForUUID(String uuid, JasperDesign jd, MReport report) {
        SpreadSheetElementsCache jdCache = cache.get(jd);
        if (jdCache == null) {
            jdCache = new SpreadSheetElementsCache(jd, report);
            cache.put(jd, jdCache);
        }
        return jdCache.getElementsFor(uuid);
    }

    @Override
    public Command deactivate(ANode selectedNode) {
        return null;
    }

    public static void refreshCache(JasperDesign jd) {
        cache.remove(jd);
    }

    @Override
    public boolean isSelectable(ANode selectedNode) {
        if (selectedNode != null) {
            for (ANode parent = selectedNode; parent != null; parent = parent.getParent()) {
                if (parent instanceof MBand) {
                    return true;
                }
                if (parent instanceof MFrame) {
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public int getInsertPosition(ANode container, Point dropPosition) {
        int index = 0;
        int offsetLeft = 0;
        if (container instanceof MBand) {
            offsetLeft += container.getJasperDesign().getLeftMargin();
        }
        for (INode child : container.getChildren()) {
            JRDesignElement jrChild = (JRDesignElement)child.getValue();
            if (jrChild.getY() < dropPosition.y && dropPosition.y < jrChild.getY() + jrChild.getHeight()) {
                int x = jrChild.getX() + offsetLeft;
                int span1 = x - 5;
                int span2 = x + 5;
                if (dropPosition.x > span1 && dropPosition.x < span2) {
                    return index;
                }
                if (dropPosition.x > (span1 += jrChild.getWidth()) && dropPosition.x < (span2 += jrChild.getWidth())) {
                    if (index < container.getChildren().size()) {
                        return index + 1;
                    }
                    return -1;
                }
            }
            ++index;
        }
        return -1;
    }
}

