/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyleTemplateReference;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshTemplateStyleReference
extends ACachedSelectionAction {
    public static final String ID = "refresh_template_style_reference";

    public RefreshTemplateStyleReference(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.RefreshTemplateStyleExpression_title);
        this.setToolTipText(Messages.RefreshTemplateStyleExpression_tooltip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/refresh_style_action.png"));
        this.setEnabled(false);
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.getSelectedStyles().isEmpty();
    }

    @Override
    public void run() {
        List<MStyleTemplateReference> references = this.getSelectedStyles();
        HashSet<MStyleTemplate> refreshedTemplate = new HashSet<MStyleTemplate>();
        JasperReportsConfiguration jconfig = null;
        for (MStyleTemplateReference template : references) {
            MStyleTemplate parentTemplate = this.getParentTemplate(template);
            if (template != null && !refreshedTemplate.contains(parentTemplate)) {
                ExternalStylesManager.refreshStyleReference(template, parentTemplate);
                refreshedTemplate.add(parentTemplate);
            } else {
                ExternalStylesManager.refreshStyleReference(template, null);
            }
            if (jconfig == null) {
                jconfig = template.getJasperConfiguration();
            }
            template.refreshChildren();
        }
        if (jconfig != null) {
            jconfig.refreshCachedStyles();
        }
    }

    protected MStyleTemplate getParentTemplate(MStyleTemplateReference template) {
        ANode parent = template.getParent();
        while (parent != null) {
            if (parent instanceof MStyleTemplate) {
                return (MStyleTemplate)parent;
            }
            if (parent instanceof MStyle) break;
            parent = parent.getParent();
        }
        return null;
    }

    private List<MStyleTemplateReference> getSelectedStyles() {
        List<Object> templates = this.editor.getSelectionCache().getSelectionModelForType(MStyleTemplateReference.class);
        ArrayList<MStyleTemplateReference> result = new ArrayList<MStyleTemplateReference>();
        for (Object template : templates) {
            result.add((MStyleTemplateReference)template);
        }
        return result;
    }
}

