/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.command.ResetConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.ResetStyleCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class ResetStyleAction
extends ACachedSelectionAction {
    public static final String ID = "reset_style_properites";

    public ResetStyleAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        super.init();
        this.setText(Messages.ResetStyleAction_actionTitle);
        this.setToolTipText(Messages.ResetStyleAction_actionTooltip);
        this.setId(ID);
        this.setEnabled(false);
    }

    @Override
    public void run() {
        JSSCompoundCommand commands = new JSSCompoundCommand(null);
        List<Object> styles = this.editor.getSelectionCache().getSelectionModelForType(MStyle.class);
        for (Object rawStyle : styles) {
            MStyle style = (MStyle)rawStyle;
            commands.setReferenceNodeIfNull(style);
            Command resetCommand = null;
            resetCommand = style.getValue() instanceof JRDesignStyle ? new ResetStyleCommand(style) : new ResetConditionalStyleCommand(style.getJasperDesign(), style);
            commands.add(resetCommand);
        }
        this.execute((Command)commands);
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> styles = this.editor.getSelectionCache().getSelectionModelForType(MStyle.class);
        if (styles.size() <= 0 || styles.size() != this.getSelectedObjects().size()) {
            return false;
        }
        for (Object style : styles) {
            if (((MStyle)style).isEditable()) continue;
            return false;
        }
        return true;
    }
}

