/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.page;

import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.IMultiEditor;
import com.jaspersoft.studio.editor.outline.JDReportOutlineView;
import com.jaspersoft.studio.editor.outline.page.EmptyOutlinePage;
import com.jaspersoft.studio.editor.xml.outline.EditorContentOutlinePage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiOutlineView
extends Page
implements IContentOutlinePage,
ISelectionProvider,
ISelectionChangedListener,
IAdaptable {
    private PageBook pagebook;
    private ISelection selection;
    private ArrayList<ISelectionChangedListener> listeners;
    private IContentOutlinePage currentPage;
    private IContentOutlinePage emptyPage;
    private IActionBars actionBars;
    private EditorPart editor;
    private boolean isRefresh = false;

    public MultiOutlineView(EditorPart editor) {
        this.getListeners();
        this.editor = editor;
    }

    public EditorPart getEditor() {
        return this.editor;
    }

    private List<ISelectionChangedListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void createControl(Composite parent) {
        IMultiEditor ed;
        IContentOutlinePage cop;
        this.pagebook = new PageBook(parent, 0);
        this.listeners = new ArrayList();
        if (this.editor instanceof IMultiEditor && (cop = (IContentOutlinePage)(ed = (IMultiEditor)this.editor).getActiveEditor().getAdapter(IContentOutlinePage.class)) != null) {
            this.setPageActive(cop);
        }
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
        this.pagebook = null;
        this.listeners = null;
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setActionBars(IActionBars actionBars) {
        this.actionBars = actionBars;
        this.registerToolbarActions(actionBars);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public void setFocus() {
        try {
            if (this.currentPage != null) {
                this.currentPage.setFocus();
            }
        }
        catch (Throwable throwable) {}
    }

    private IContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    public void setPageActive(IContentOutlinePage page) {
        Object jdoutpage;
        if (this.isRefresh) {
            return;
        }
        this.isRefresh = true;
        if (page == null) {
            page = this.getEmptyPage();
        }
        Control control = page.getControl();
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.getActionBars() != null && this.getActionBars().getToolBarManager() != null) {
            this.getActionBars().getToolBarManager().removeAll();
            if (page != null && page instanceof JDReportOutlineView) {
                ((JDReportOutlineView)page).registerToolbarAction(this.getActionBars().getToolBarManager());
            }
        }
        if (this.getSite() != null && page instanceof JDReportOutlineView) {
            IGraphicalEditor ed;
            jdoutpage = (JDReportOutlineView)page;
            if (page.getControl() != null && page.getControl().isDisposed() && (ed = ((JDReportOutlineView)((Object)jdoutpage)).getEditor()) instanceof IAdaptable) {
                page = (IContentOutlinePage)((IAdaptable)ed).getAdapter(IContentOutlinePage.class);
            }
            ((JDReportOutlineView)((Object)jdoutpage)).init(this.getSite());
        }
        page.addSelectionChangedListener((ISelectionChangedListener)this);
        this.currentPage = page;
        if (this.pagebook == null) {
            this.isRefresh = false;
            return;
        }
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            if (this.getActionBars() != null) {
                page.setActionBars(this.getActionBars());
            }
            control = page.getControl();
        }
        this.pagebook.showPage(control);
        if (page instanceof JDReportOutlineView) {
            jdoutpage = (JDReportOutlineView)page;
            ((JDReportOutlineView)((Object)jdoutpage)).setTreeSelection(this.selection);
        } else if (page instanceof EditorContentOutlinePage) {
            jdoutpage = (EditorContentOutlinePage)page;
            ((EditorContentOutlinePage)((Object)jdoutpage)).update();
        } else {
            this.setSelection(page.getSelection());
        }
        if (this.getActionBars() != null && this.getActionBars().getToolBarManager() != null) {
            this.getActionBars().getToolBarManager().update(true);
        }
        this.isRefresh = false;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null || selection == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(e);
            ++i;
        }
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
    }

    public Object getAdapter(Class adapter) {
        if (this.currentPage instanceof IAdaptable && this.currentPage != this) {
            return ((IAdaptable)this.currentPage).getAdapter(adapter);
        }
        return null;
    }
}

