/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.part;

import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.JDContainerEditPolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.JDTreeContainerEditPolicy;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.editor.report.EditorContributor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;

public class ContainerTreeEditPart
extends TreeEditPart {
    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new JDContainerEditPolicy());
        this.installEditPolicy("TreeContainerEditPolicy", (EditPolicy)new JDTreeContainerEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        if (this.getParent() instanceof RootEditPart) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        }
    }

    public boolean understandsRequest(Request req) {
        if ("align".equals(req.getType()) && this.getModel() instanceof MGraphicElement) {
            return true;
        }
        if ("open".equals(req.getType()) && this.getModel() instanceof MConditionalStyle) {
            return true;
        }
        return super.understandsRequest(req);
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        this.showTargetFeedbackOnEditor(request);
    }

    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        this.eraseTargetFeedbackOnEditor(request);
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && this.getModel() instanceof MConditionalStyle) {
            MConditionalStyle cStyle = (MConditionalStyle)this.getModel();
            JRDesignConditionalStyle jrCStyle = (JRDesignConditionalStyle)cStyle.getValue();
            if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                JRExpressionEditor wizard = new JRExpressionEditor();
                wizard.setValue((JRDesignExpression)jrCStyle.getConditionExpression());
                wizard.setExpressionContext(ExpressionEditorSupportUtil.getReportExtendedExpressionContext());
                WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(UIUtils.getShell(), wizard);
                if (dialog.open() == 0) {
                    IEditorPart editor = SelectionHelper.getActiveJRXMLEditor();
                    EditorContributor provider = (EditorContributor)editor.getAdapter(EditorContributor.class);
                    if (provider != null) {
                        CommandStack stack = provider.getEditDomain().getCommandStack();
                        SetValueCommand setExpCommand = new SetValueCommand(Messages.MConditionalStyle_conditional_expression);
                        setExpCommand.setTarget(cStyle);
                        setExpCommand.setPropertyId("conditionExpression");
                        setExpCommand.setPropertyValue(wizard.getValue());
                        stack.execute((Command)setExpCommand);
                    } else {
                        jrCStyle.setConditionExpression((JRExpression)wizard.getValue());
                    }
                }
            }
        }
        super.performRequest(req);
    }
}

