/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.palette;

import com.jaspersoft.studio.editor.tools.CompositeElementTemplateCreationEntry;
import com.jaspersoft.studio.editor.tools.DeleteCompositeElementAction;
import com.jaspersoft.studio.editor.tools.EditCompositeElementAction;
import com.jaspersoft.studio.editor.tools.ExportCompositeElementAction;
import com.jaspersoft.studio.editor.tools.ImportCompositeElementAction;
import com.jaspersoft.studio.editor.tools.OpenElementInDesignerAction;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class JSSPaletteContextMenuProvider
extends PaletteContextMenuProvider {
    public static final String MANAGE_ELEMENT = "com.jaspersoft.studio.editor.palette.composite_element.manage";
    public static final String IMPORT_ELEMENT = "com.jaspersoft.studio.editor.palette.composite_element.importexport";

    public JSSPaletteContextMenuProvider(PaletteViewer palette) {
        super(palette);
    }

    protected CompositeElementTemplateCreationEntry getSelectedCompositeElement() {
        EditPart selectedPart;
        if (this.getPaletteViewer().getSelectedEditParts().size() == 1 && (selectedPart = (EditPart)this.getPaletteViewer().getSelectedEditParts().get(0)).getModel() instanceof CompositeElementTemplateCreationEntry) {
            return (CompositeElementTemplateCreationEntry)((Object)selectedPart.getModel());
        }
        return null;
    }

    public void buildContextMenu(IMenuManager menu) {
        CompositeElementTemplateCreationEntry selectedElement = this.getSelectedCompositeElement();
        if (selectedElement != null) {
            menu.add((IContributionItem)new Separator(MANAGE_ELEMENT));
            menu.appendToGroup(MANAGE_ELEMENT, (IAction)new EditCompositeElementAction(selectedElement));
            menu.appendToGroup(MANAGE_ELEMENT, (IAction)new OpenElementInDesignerAction(selectedElement));
            menu.appendToGroup(MANAGE_ELEMENT, (IAction)new DeleteCompositeElementAction(selectedElement));
        }
        menu.add((IContributionItem)new Separator(IMPORT_ELEMENT));
        if (selectedElement != null) {
            menu.appendToGroup(IMPORT_ELEMENT, (IAction)new ExportCompositeElementAction(selectedElement));
        }
        menu.appendToGroup(IMPORT_ELEMENT, (IAction)new ImportCompositeElementAction());
        super.buildContextMenu(menu);
    }
}

