/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.part;

import com.jaspersoft.studio.editor.part.TFItem;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TFContainer
extends Composite {
    private StackLayout stackLayout;
    private ToolBar toolBar;
    private ToolBar additionalToolbar;
    private ToolBarManager additionalToolbarManager;
    private List<TFItem> tfitems = new ArrayList<TFItem>();
    private int selection = -1;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private Composite content;

    public TFContainer(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.toolBar = new ToolBar((Composite)this, 8519936);
        this.toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.additionalToolbar = new ToolBar((Composite)this, 8519936);
        GridData additionalToolbarGD = new GridData(131072, 0x1000000, true, false);
        this.additionalToolbar.setLayoutData((Object)additionalToolbarGD);
        this.additionalToolbarManager = new ToolBarManager(this.additionalToolbar);
        this.content = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.content.setLayout((Layout)this.stackLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    public Composite getContent() {
        return this.content;
    }

    public int indexOf(TFItem item) {
        return this.tfitems.indexOf((Object)item);
    }

    public int getSelectionIndex() {
        return this.selection;
    }

    public void setSelection(int selection) {
        TFItem tfItem;
        this.selection = selection;
        int i = 0;
        while (i < this.toolBar.getItemCount()) {
            this.toolBar.getItem(i).setSelection(i == selection);
            ++i;
        }
        this.stackLayout.topControl = this.getItem(selection).getControl();
        Object data = this.toolBar.getItem(selection).getData();
        if (data instanceof TFItem && (tfItem = (TFItem)((Object)data)).getData() instanceof AbstractVisualEditor) {
            this.populateAdditionalToolbar((AbstractVisualEditor)tfItem.getData());
        }
        this.getParent().layout();
    }

    public void removeItem(TFItem item) {
        int index = this.tfitems.indexOf((Object)item);
        this.toolBar.getItem(index).dispose();
        this.tfitems.remove((Object)item);
        this.toolBar.update();
        this.pack();
        this.layout(true);
        if (index == this.selection) {
            this.setSelection(--index);
        }
    }

    public TFItem getItem(int selectedIndex) {
        return this.tfitems.get(selectedIndex);
    }

    public int getItemCount() {
        return this.tfitems.size();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void createItem(final TFItem item, int index) {
        final ToolItem ti = new ToolItem(this.toolBar, 16);
        ti.setText("Item1" + item.getText());
        ti.setData((Object)item);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ti.getSelection() && TFContainer.this.tfitems.indexOf((Object)item) != TFContainer.this.selection) {
                    for (SelectionListener sl : TFContainer.this.listeners) {
                        sl.widgetSelected(e);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tfitems.add(index, item);
        this.toolBar.update();
        this.pack();
        this.layout(true);
    }

    public void update(TFItem tfItem) {
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem it = toolItemArray[n2];
            if (it.getData() == tfItem) {
                it.setText(tfItem.getText());
                it.setImage(tfItem.getImage());
                this.toolBar.update();
                this.layout(true);
                break;
            }
            ++n2;
        }
    }

    private void populateAdditionalToolbar(AbstractVisualEditor editor) {
        this.additionalToolbarManager.removeAll();
        editor.contributeItemsToEditorTopToolbar((IToolBarManager)this.additionalToolbarManager);
        this.additionalToolbarManager.update(true);
    }
}

