/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.actions;

import com.jaspersoft.studio.editor.preview.MultiPageContainer;
import com.jaspersoft.studio.editor.preview.view.AViewsFactory;
import com.jaspersoft.studio.messages.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SwitchViewsAction
extends Action
implements IMenuCreator {
    public static final String SEPARATOR = "SEPARATOR";
    private MultiPageContainer container;
    protected String view;
    private boolean changeName = true;
    private AViewsFactory viewFactory;
    private Menu listMenu;

    public SwitchViewsAction(MultiPageContainer container, String view, boolean changeName, AViewsFactory viewFactory) {
        super(view, 4);
        this.setToolTipText(Messages.SwitchViewsAction_actionTooltip);
        this.setMenuCreator(this);
        this.viewFactory = viewFactory;
        this.container = container;
        this.view = view;
        this.changeName = changeName;
    }

    public void dispose() {
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
        this.listMenu = new Menu(parent);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.getSource();
                menuItem.setSelection(true);
                SwitchViewsAction.this.view = (String)menuItem.getData("view.key");
                SwitchViewsAction.this.run();
            }
        };
        for (String key : this.container.getKeys()) {
            if (key.startsWith(SEPARATOR)) {
                new MenuItem(this.listMenu, 2);
                continue;
            }
            MenuItem m1 = new MenuItem(this.listMenu, 16);
            m1.setText(this.viewFactory.getLabel(key));
            m1.addSelectionListener((SelectionListener)listener);
            m1.setData("view.key", (Object)key);
        }
        return this.listMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        if (this.view != null) {
            if (this.changeName) {
                this.setText(this.viewFactory.getLabel(this.view));
            }
            this.container.switchView(this.view);
            this.container.afterSwitchView();
        }
    }
}

