/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.datasnapshot;

import com.jaspersoft.studio.editor.preview.datasnapshot.DataSnapshotManager;
import com.jaspersoft.studio.editor.preview.datasnapshot.JSSColumnDataCacheHandler;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.SimpleReportContext;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class DatasnapshotDialog
extends ATitledDialog {
    private Button bSnapshot;
    private Text tFile;
    private JasperReportsConfiguration jConfig;
    private Button bFile;
    private Label lfile;

    public DatasnapshotDialog(Shell parentShell, JasperReportsConfiguration jConfig) {
        super(parentShell, false);
        this.setTitle(Messages.DatasnapshotDialog_0);
        this.jConfig = jConfig;
    }

    protected void okPressed() {
        if (this.canHandleShellCloseEvent()) {
            Map<String, Object> hm = this.jConfig.getJRParameters();
            SimpleReportContext reportContext = (SimpleReportContext)hm.get("REPORT_CONTEXT");
            if (this.bSnapshot.getSelection()) {
                DataSnapshotManager.setCaching(hm, true);
                reportContext = (SimpleReportContext)hm.computeIfAbsent("REPORT_CONTEXT", k -> new SimpleReportContext());
                String fname = (String)this.jConfig.getMap().get("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
                reportContext.setParameterValue("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", (Object)fname);
                if (!Misc.isNullOrEmpty((String)this.tFile.getText())) {
                    fname = this.tFile.getText().trim();
                    DataCacheHandler cacheHandler = DataSnapshotManager.setDataSnapshot(hm, false);
                    if (cacheHandler.getDataSnapshot() != null) {
                        Date creationTimestamp = new Date();
                        if (cacheHandler instanceof JSSColumnDataCacheHandler) {
                            creationTimestamp = ((JSSColumnDataCacheHandler)cacheHandler).getCreationTimestamp();
                        }
                        DataSnapshotManager.saveSnapshot(fname, creationTimestamp, cacheHandler.getDataSnapshot());
                    }
                    reportContext.setParameterValue("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", (Object)fname);
                    this.jConfig.getMap().put("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
                    this.jConfig.getJasperDesign().setProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
                } else {
                    DataSnapshotManager.removeSnapshotFile(hm);
                    this.jConfig.getJasperDesign().removeProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
                }
            } else {
                DataSnapshotManager.setCaching(hm, false);
                if (reportContext != null) {
                    Map pv = reportContext.getParameterValues();
                    String fname = (String)pv.get("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
                    if (fname != null) {
                        this.jConfig.getMap().put("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
                    }
                    pv.remove("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
                }
                DataSnapshotManager.removeSnapshotFile(hm);
                this.jConfig.getJasperDesign().removeProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT");
            }
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.bSnapshot = new Button(cmp, 32);
        this.bSnapshot.setText(Messages.DatasnapshotDialog_1);
        this.bSnapshot.setToolTipText(Messages.DatasnapshotDialog_2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.bSnapshot.setLayoutData((Object)gd);
        this.bSnapshot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasnapshotDialog.this.enableFile();
            }
        });
        this.lfile = new Label(cmp, 0);
        this.lfile.setText(Messages.DatasnapshotDialog_3);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 18;
        gd.verticalIndent = 10;
        this.lfile.setLayoutData((Object)gd);
        this.tFile = new Text(cmp, 2048);
        this.tFile.setToolTipText(Messages.DatasnapshotDialog_4);
        gd = new GridData(768);
        gd.widthHint = 400;
        gd.horizontalIndent = 18;
        this.tFile.setLayoutData((Object)gd);
        this.tFile.addModifyListener(e -> {
            String tt = this.tFile.getText();
            if (!tt.isEmpty()) {
                tt = String.valueOf(tt) + "\n\n";
            }
            tt = String.valueOf(tt) + Messages.DatasnapshotDialog_4;
            this.tFile.setToolTipText(tt);
        });
        this.tFile.addModifyListener(e -> this.validate());
        this.bFile = new Button(cmp, 8);
        this.bFile.setText("...");
        this.bFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(DatasnapshotDialog.this.bFile.getShell(), 8192);
                fd.setText(Messages.PreviewTopToolBarManager_3);
                IFile f = (IFile)DatasnapshotDialog.this.jConfig.get("ifile");
                String sname = String.valueOf(FilenameUtils.getBaseName((String)f.getName())) + ".jrds";
                String folder = f.getParent().getLocation().toOSString();
                fd.setFilterPath(folder);
                fd.setFileName(sname);
                fd.setFilterExtensions(new String[]{"*.jrds", "*.*"});
                String fname = fd.open();
                if (fname != null) {
                    if ((String.valueOf(folder) + File.separator + sname).equals(fname)) {
                        fname = sname;
                    }
                    DatasnapshotDialog.this.tFile.setText(fname);
                }
            }
        });
        this.init();
        return cmp;
    }

    private void init() {
        String file = DataSnapshotManager.getSnapshotFile(this.jConfig);
        this.bSnapshot.setSelection(DataSnapshotManager.snapshotExists(this.jConfig.getJRParameters()));
        if (this.bSnapshot.getSelection()) {
            this.tFile.setText(Misc.nvl((String)file));
        }
        this.enableFile();
    }

    protected void enableFile() {
        if (!this.bSnapshot.getSelection()) {
            this.tFile.setText("");
        }
        this.tFile.setEnabled(this.bSnapshot.getSelection());
        this.bFile.setEnabled(this.bSnapshot.getSelection());
        this.lfile.setForeground(this.bSnapshot.getSelection() ? null : SWTResourceManager.getColor((int)15));
    }

    protected void validate() {
        try {
            String t = this.tFile.getText();
            if (!t.isEmpty()) {
                new File(t).getCanonicalPath();
                this.setError(null);
            }
        }
        catch (Exception exception) {
            this.setError("Invalid file path");
        }
    }
}

