/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanInput
extends ADataInput {
    private Button bbuton;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Boolean.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, IParameter prm, Map<String, Object> params) {
        super.createInput(parent, prm, params);
        if (this.isForType(prm.getValueClass())) {
            this.bbuton = new Button(parent, 32);
            this.bbuton.setText(prm.getLabel());
            this.bbuton.setToolTipText(prm.getDescription());
            this.bbuton.addFocusListener(this.focusListener);
            this.bbuton.addTraverseListener(this.keyListener);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.bbuton.setLayoutData((Object)gd);
            this.bbuton.setBackground(parent.getBackground());
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BooleanInput.this.updateModel(new Boolean(BooleanInput.this.bbuton.getSelection()));
                    BooleanInput.this.setDecoratorNullable(BooleanInput.this.param);
                }
            };
            this.bbuton.addSelectionListener((SelectionListener)listener);
            this.setNullable(prm, (Control)this.bbuton);
            this.updateInput();
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            value = Boolean.valueOf((String)value);
        }
        if (value != null && value instanceof Boolean) {
            this.bbuton.setSelection(((Boolean)value).booleanValue());
        } else {
            this.bbuton.setSelection(false);
        }
        this.setDecoratorNullable(this.param);
    }

    @Override
    public boolean isLabeled() {
        return true;
    }
}

