/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumInput
extends ADataInput {
    private Combo cmb;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return valueClass.isEnum();
    }

    @Override
    public void createInput(Composite parent, final IParameter prm, Map<String, Object> params) {
        super.createInput(parent, prm, params);
        if (this.isForType(prm.getValueClass())) {
            this.cmb = new Combo(parent, 8);
            this.cmb.setText(prm.getLabel());
            this.cmb.setToolTipText(prm.getDescription());
            this.cmb.addFocusListener(this.focusListener);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.cmb.setLayoutData((Object)gd);
            ArrayList<String> values = new ArrayList<String>();
            values.add("");
            ?[] objArray = prm.getValueClass().getEnumConstants();
            int n = objArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objArray[n2];
                values.add(obj.toString());
                ++n2;
            }
            this.cmb.setItems(values.toArray(new String[values.size()]));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnumInput.this.updateModel(EnumInput.this.cmb.getText().isEmpty() ? null : Enum.valueOf(prm.getValueClass(), EnumInput.this.cmb.getText()));
                    EnumInput.this.setDecoratorNullable(EnumInput.this.param);
                }
            };
            this.cmb.addSelectionListener((SelectionListener)listener);
            this.setNullable(prm, (Control)this.cmb);
            this.updateInput();
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof Enum) {
            value = ((Enum)value).name();
        }
        if (value != null && value instanceof String) {
            int i = 0;
            String[] stringArray = this.cmb.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(value)) {
                    this.cmb.select(i);
                }
                ++i;
                ++n2;
            }
        }
        this.setDecoratorNullable(this.param);
    }
}

