/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class FileInput
extends ADataInput {
    private Text txt;
    private Button btn;
    private boolean isRefresh = false;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return File.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            Composite cmp = new Composite(parent, 0);
            GridData gd = new GridData(768);
            cmp.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmp.setLayout((Layout)layout);
            this.txt = new Text(cmp, 2048);
            this.txt.setToolTipText(VParameters.createToolTip(param));
            this.txt.addFocusListener(this.focusListener);
            this.txt.addTraverseListener(this.keyListener);
            gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.txt.setLayoutData((Object)gd);
            FileInput.setMandatory(param, (Control)this.txt);
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FileInput.this.isRefresh) {
                        FileInput.hideError((Control)FileInput.this.txt);
                        if (param.getValueClass().equals(File.class)) {
                            try {
                                File f = new File(FileInput.this.txt.getText());
                                if (!f.exists()) {
                                    FileInput.setError((Control)FileInput.this.txt, "File does not exists");
                                }
                                FileInput.this.updateModel(f);
                            }
                            catch (Exception e1) {
                                FileInput.setError((Control)FileInput.this.txt, e1.getMessage());
                            }
                        }
                    }
                }
            };
            this.txt.addModifyListener(listener);
            this.btn = new Button(cmp, 8);
            this.btn.setText(Messages.FileInput_selectfile);
            this.btn.setToolTipText(param.getDescription());
            this.btn.addFocusListener(this.focusListener);
            this.btn.addTraverseListener(this.keyListener);
            this.btn.setAlignment(16384);
            this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilteredResourcesSelectionDialog fd = new FilteredResourcesSelectionDialog(Display.getCurrent().getActiveShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                    if (fd.open() == 0) {
                        IFile file = (IFile)fd.getFirstResult();
                        FileInput.this.txt.setText(Misc.nvl((String)file.getProjectRelativePath().toOSString()));
                        FileInput.this.updateModel(new File(file.getLocationURI()));
                    }
                }
            });
            this.updateInput();
            this.setNullable(param, (Control)this.btn);
            this.setNullable(param, (Control)this.txt);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        this.isRefresh = true;
        if (value != null && value instanceof String) {
            this.txt.setText((String)value);
        } else {
            this.txt.setText(value == null ? "" : value.toString());
        }
        this.isRefresh = false;
        if (value != null && value instanceof File) {
            this.btn.setToolTipText(((File)value).getAbsolutePath());
        }
        this.setDecoratorNullable(this.param);
    }
}

