/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.messages.Messages;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ImageInput
extends ADataInput {
    private Text txt;
    private Button btn;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Image.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            Composite cmp = new Composite(parent, 0);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            cmp.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmp.setLayout((Layout)layout);
            this.txt = new Text(cmp, 2048);
            this.txt.setToolTipText(VParameters.createToolTip(param));
            this.txt.addFocusListener(this.focusListener);
            this.txt.addTraverseListener(this.keyListener);
            this.txt.setLayoutData((Object)new GridData(768));
            ImageInput.setMandatory(param, (Control)this.txt);
            this.btn = new Button(cmp, 0);
            this.btn.setText(Messages.ImageInput_selectimage);
            this.btn.setToolTipText(param.getDescription());
            this.btn.addFocusListener(this.focusListener);
            this.btn.addTraverseListener(this.keyListener);
            this.btn.setAlignment(16384);
            this.btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilteredResourcesSelectionDialog fd = new FilteredResourcesSelectionDialog(Display.getCurrent().getActiveShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                    fd.setInitialPattern("*.png");
                    if (fd.open() == 0) {
                        IFile file = (IFile)fd.getFirstResult();
                        try {
                            BufferedImage image = ImageIO.read(file.getContents());
                            ImageInput.this.txt.setText(Misc.nvl((String)file.getProjectRelativePath().toOSString()));
                            ImageInput.this.updateModel(image);
                            ImageInput.setButtonImage(ImageInput.this.btn, image);
                        }
                        catch (Exception e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updateInput();
            this.setNullable(param, (Control)this.btn);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            this.txt.setText((String)value);
        } else if (value != null && value instanceof Image) {
            ImageInput.setButtonImage(this.btn, (Image)value);
        } else {
            this.txt.setText(value == null ? "" : value.toString());
        }
        this.setDecoratorNullable(this.param);
    }

    public static void setButtonImage(Button txt, Image image) {
        org.eclipse.swt.graphics.Image img = new org.eclipse.swt.graphics.Image((Device)txt.getDisplay(), ImageInput.convertAWTImageToSWT(image).scaledTo(50, 50));
        txt.setImage(img);
    }

    public static ImageData convertAWTImageToSWT(Image image) {
        if (image == null) {
            throw new IllegalArgumentException(Messages.ImageInput_nullimage);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w == -1 || h == -1) {
            return null;
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return ImageInput.convertToSWT(bi);
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

