/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.PatternEditor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PatternInput
extends ADataInput {
    private Text txt;
    private boolean isRefresh = false;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return NumberFormat.class.isAssignableFrom(valueClass) || DateFormat.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            final Composite cmp = new Composite(parent, 0);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            cmp.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmp.setLayout((Layout)layout);
            this.txt = new Text(cmp, 2048);
            this.txt.setToolTipText(VParameters.createToolTip(param));
            this.txt.addFocusListener(this.focusListener);
            this.txt.addTraverseListener(this.keyListener);
            this.txt.setLayoutData((Object)new GridData(768));
            PatternInput.setMandatory(param, (Control)this.txt);
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!PatternInput.this.isRefresh) {
                        String tpattern = PatternInput.this.txt.getText();
                        if (param.getValueClass().equals(NumberFormat.class)) {
                            PatternInput.this.updateModel(tpattern == null ? null : new DecimalFormat(tpattern));
                        } else if (param.getValueClass().equals(DateFormat.class)) {
                            PatternInput.this.updateModel(tpattern == null ? null : new SimpleDateFormat(PatternInput.this.txt.getText()));
                        }
                    }
                }
            };
            this.txt.addModifyListener(listener);
            Button btn = new Button(cmp, 8);
            btn.setText("...");
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatternEditor wizard = new PatternEditor();
                    wizard.setValue(PatternInput.this.txt.getText());
                    if (param.getValueClass().equals(NumberFormat.class)) {
                        wizard.setDatePatterns(false);
                    } else if (param.getValueClass().equals(DateFormat.class)) {
                        wizard.setNumberPatterns(false);
                    }
                    WizardDialog dialog = new WizardDialog(cmp.getShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        String tpattern = wizard.getValue();
                        PatternInput.this.txt.setText(Misc.nvl((String)tpattern));
                        if (param.getValueClass().equals(NumberFormat.class)) {
                            PatternInput.this.updateModel(tpattern == null ? null : new DecimalFormat(tpattern));
                        } else if (param.getValueClass().equals(DateFormat.class)) {
                            PatternInput.this.updateModel(tpattern == null ? null : new SimpleDateFormat(PatternInput.this.txt.getText()));
                        }
                    }
                }
            });
            this.updateInput();
            this.setNullable(param, (Control)this.txt);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            this.txt.setText((String)value);
        } else {
            this.isRefresh = true;
            this.txt.setText(value == null ? "" : this.getPattern(value));
            this.isRefresh = false;
        }
        this.setDecoratorNullable(this.param);
    }

    private String getPattern(Object value) {
        if (value instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)value).toPattern();
        }
        if (value instanceof DecimalFormat) {
            return ((DecimalFormat)value).toPattern();
        }
        return value.toString();
    }
}

