/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input.array;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.ParameterJasper;
import com.jaspersoft.studio.editor.preview.input.array.TableDialog;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CollectionInput
extends ADataInput {
    private Button bbuton;
    private Text label;
    private boolean refreshing = false;
    private final int SHORTLENGHT = 15;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Collection.class.isAssignableFrom(valueClass) || valueClass.isArray();
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            Composite cmp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cmp.setLayout((Layout)layout);
            cmp.setLayoutData((Object)new GridData(768));
            this.label = new Text(cmp, 2112);
            String tt = "You can write strings separated by comma. Exemple: Bob,Tom,Sara\n";
            tt = String.valueOf(tt) + param.getDescription();
            this.label.setToolTipText(tt);
            this.label.setLayoutData((Object)new GridData(1808));
            this.label.addTraverseListener(this.keyListener);
            this.label.addModifyListener(e -> {
                Map p;
                Object value;
                Class c;
                if (this.refreshing) {
                    return;
                }
                String txt = this.label.getText();
                Object[] s = txt.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
                if (param instanceof ParameterJasper && (c = ((ParameterJasper)param).getParam().getNestedType()) != null) {
                    Object[] o = new Object[s.length];
                    int nulls = 0;
                    int i = 0;
                    while (i < s.length) {
                        try {
                            if (Misc.isNullOrEmpty((String)s[i])) {
                                ++nulls;
                            } else if (c.isAssignableFrom(Integer.class)) {
                                o[i] = Integer.parseInt((String)s[i]);
                            } else if (c.isAssignableFrom(Byte.class)) {
                                o[i] = Byte.parseByte((String)s[i]);
                            } else if (c.isAssignableFrom(Short.class)) {
                                o[i] = Short.parseShort((String)s[i]);
                            } else if (c.isAssignableFrom(BigInteger.class)) {
                                o[i] = new BigInteger((String)s[i]);
                            } else if (c.isAssignableFrom(Long.class)) {
                                o[i] = Long.parseLong((String)s[i]);
                            } else if (c.isAssignableFrom(Float.class)) {
                                o[i] = Float.valueOf(Float.parseFloat((String)s[i]));
                            } else if (c.isAssignableFrom(Double.class)) {
                                o[i] = Double.parseDouble((String)s[i]);
                            } else if (c.isAssignableFrom(BigDecimal.class)) {
                                o[i] = new BigDecimal((String)s[i]);
                            } else if (c.isAssignableFrom(Boolean.class)) {
                                o[i] = new Boolean((String)s[i]);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            ++nulls;
                        }
                        ++i;
                    }
                    if (nulls > 0) {
                        s = new Object[o.length - nulls];
                        i = 0;
                        int j = 0;
                        while (i < o.length) {
                            if (o[i] != null) {
                                s[j] = o[i];
                                ++j;
                            }
                            ++i;
                        }
                    } else {
                        s = o;
                    }
                }
                if ((value = (p = this.params).get(param.getName())) == null) {
                    return;
                }
                if (value.getClass().isArray()) {
                    value = s;
                } else if (value instanceof Collection) {
                    if (value instanceof List) {
                        value = new ArrayList();
                    } else {
                        ((Collection)value).clear();
                    }
                    Object[] objectArray = s;
                    int n = s.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        ((Collection)value).add(item);
                        ++n2;
                    }
                }
                this.updateModel(value);
            });
            this.bbuton = new Button(cmp, 8);
            this.bbuton.setText("...");
            this.bbuton.setToolTipText(param.getDescription());
            this.bbuton.addFocusListener(this.focusListener);
            this.bbuton.addTraverseListener(this.keyListener);
            this.bbuton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Map p = CollectionInput.this.params;
                    Object value = p.get(param.getName());
                    if (value == null) {
                        try {
                            value = param.getValueClass().newInstance();
                        }
                        catch (InstantiationException instantiationException) {
                            if (param.getValueClass().isArray() || param.getValueClass().isAssignableFrom(List.class)) {
                                value = new ArrayList();
                            } else if (param.getValueClass().isAssignableFrom(Set.class)) {
                                value = new HashSet();
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    } else if (value.getClass().isArray()) {
                        value = Arrays.asList((Object[])value);
                    }
                    TableDialog d = new TableDialog(CollectionInput.this.bbuton.getShell(), value, param);
                    if (d.open() == 0) {
                        Object[] val = d.getValue();
                        if (param.getValueClass().isArray()) {
                            List list = (List)val;
                            val = list.toArray((Object[])Array.newInstance(param.getValueClass().getComponentType(), list.size()));
                        }
                        CollectionInput.this.updateModel(val);
                        CollectionInput.this.updateInput();
                    }
                }
            });
            this.updateInput();
            this.setNullable(param, (Control)this.label);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        String del = "";
        String lblText = "";
        if (value != null && value instanceof Collection) {
            for (Object obj : (Collection)value) {
                lblText = String.valueOf(lblText) + del + this.getLabelText(obj);
                del = ",";
            }
        } else if (value != null && value.getClass().isArray()) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj;
                obj = objectArray[n2];
                lblText = String.valueOf(lblText) + del + this.getLabelText(obj);
                del = ",";
                ++n2;
            }
        }
        if (lblText.isEmpty()) {
            lblText = "No elements";
        }
        try {
            this.refreshing = true;
            this.label.setText(lblText);
        }
        finally {
            this.refreshing = false;
        }
    }

    private String getLabelText(Object element) {
        String t = element.toString();
        if (!(element instanceof String)) {
            if (t.length() > 15) {
                t = String.valueOf(t.substring(0, 12)) + "...";
            }
            return t;
        }
        if (t.contains(",")) {
            t = "\"" + t + "\"";
        }
        return t;
    }
}

