/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input.array;

import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.array.ElementDialog;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableDialog
extends PersistentLocationDialog {
    private IParameter prm;
    private Table table;
    private TableViewer tableViewer;
    private List<?> value;
    private Object oldValue;
    private EditElement editElement;

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
        if (code == 0) {
            this.value = (List)this.tableViewer.getInput();
            if (this.oldValue instanceof Collection) {
                if (this.oldValue instanceof List) {
                    this.oldValue = this.value;
                } else {
                    ((Collection)this.oldValue).clear();
                    ((Collection)this.oldValue).addAll(this.value);
                }
            } else if (this.oldValue.getClass().isArray()) {
                this.oldValue = this.value.toArray();
            }
        }
    }

    public Object getValue() {
        return this.oldValue;
    }

    public TableDialog(Shell parentShell, Object value, IParameter prm) {
        super(parentShell);
        this.oldValue = value;
        if (value.getClass().isArray()) {
            this.value = new ArrayList<Object>(Arrays.asList(value));
        } else if (value instanceof Collection) {
            this.value = new ArrayList((Collection)value);
        }
        this.prm = prm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Parameter: " + this.prm.getName());
    }

    protected Control createDialogArea(final Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        ((GridLayout)cmp.getLayout()).numColumns = 2;
        ((GridLayout)cmp.getLayout()).makeColumnsEqualWidth = false;
        Label lbl = new Label(cmp, 64);
        String prmDescription = this.prm.getDescription();
        lbl.setText(prmDescription != null ? prmDescription : "");
        lbl.setToolTipText(this.prm.getDescription());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.buildTable(cmp);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                int indx;
                ElementDialog d = new ElementDialog(parent.getShell(), TableDialog.this.prm);
                if (input != null && !input.isEmpty() && (indx = TableDialog.this.table.getSelectionIndex()) >= 0 && indx < input.size()) {
                    d.setType(input.get(indx));
                }
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }
        });
        this.editElement = new EditElement();
        new EditButton<Object>().createEditButtons(bGroup, this.tableViewer, this.editElement);
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        if (this.prm.getValueClass().isArray() || this.prm.getValueClass().isAssignableFrom(List.class)) {
            new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        }
        return cmp;
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 350;
        gd.widthHint = 300;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tlayout);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Value");
        column.pack();
        this.tableViewer.setInput(this.value);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                StructuredSelection s = (StructuredSelection)TableDialog.this.tableViewer.getSelection();
                ArrayList<Object> inlist = (ArrayList<Object>)TableDialog.this.tableViewer.getInput();
                if (inlist == null) {
                    inlist = new ArrayList<Object>();
                    TableDialog.this.tableViewer.setInput(inlist);
                }
                int index = -1;
                if (s.isEmpty()) {
                    return;
                }
                index = inlist.indexOf(s.getFirstElement());
                TableDialog.this.editElement.editElement((List<Object>)inlist, index);
                TableDialog.this.tableViewer.refresh();
                TableDialog.this.tableViewer.setSelection((ISelection)s);
                TableDialog.this.tableViewer.reveal(s.getFirstElement());
            }
        });
    }

    private final class EditElement
    implements IEditElement<Object> {
        private EditElement() {
        }

        @Override
        public void editElement(List<Object> input, int pos) {
            Object v = input.get(pos);
            if (v == null) {
                return;
            }
            ElementDialog dialog = new ElementDialog(TableDialog.this.table.getShell(), TableDialog.this.prm);
            dialog.setValue(v);
            if (dialog.open() == 0) {
                input.set(pos, dialog.getValue());
            }
        }
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null) {
                if (element instanceof Date) {
                    return new SimpleDateFormat().format(element);
                }
                return element.toString();
            }
            return "";
        }
    }
}

