/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input.array.number;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.array.StringElement;
import java.text.NumberFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class ANumberElement
extends StringElement {
    @Override
    protected int getStyle() {
        return super.getStyle() | 0x20000;
    }

    @Override
    public Control createControl(Composite parent) {
        super.createControl(parent);
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                try {
                    ADataInput.hideError((Control)ANumberElement.this.text);
                    String number = e.text;
                    String oldText = ((Text)e.widget).getText();
                    if (e.start != e.end) {
                        oldText = String.valueOf(oldText.substring(0, e.start)) + oldText.substring(e.end);
                    }
                    number = String.valueOf(oldText.substring(0, e.start)) + e.text;
                    if (oldText.length() - 1 > e.start + 1) {
                        number = String.valueOf(number) + oldText.substring(e.start + 1);
                    }
                    if (number.equals("-")) {
                        number = "-0";
                    }
                    if (number.equals(".")) {
                        number = "0.";
                    }
                    if (number.isEmpty()) {
                        e.doit = true;
                        return;
                    }
                    e.doit = ANumberElement.this.isValid(number);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        try {
            if (this.getValue() != null && this.getValue() instanceof Number) {
                this.text.setText(NumberFormat.getInstance().format(this.getValue()));
            }
        }
        catch (Throwable throwable) {}
        return this.text;
    }

    protected abstract boolean isValid(String var1);
}

