/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Statistics {
    private Map<String, Object> durations = new ConcurrentHashMap<String, Object>();

    public Duration startCount(String key) {
        Duration d = new Duration();
        this.durations.put(key, d);
        return d;
    }

    public void endCount(String key) {
        Object obj = this.durations.get(key);
        if (obj != null && obj instanceof Duration) {
            ((Duration)obj).stop();
        }
    }

    public long getDuration(String key) {
        Object obj = this.durations.get(key);
        if (obj != null && obj instanceof Duration) {
            return ((Duration)obj).getDuration();
        }
        return 0L;
    }

    public void setValue(String key, Object value) {
        this.durations.put(key, value);
    }

    public Object getValue(String key) {
        return this.durations.get(key);
    }

    public class Duration {
        long start;
        long end;

        public Duration() {
            this.end = this.start = 0L;
            this.end = this.start = System.currentTimeMillis();
        }

        public void stop() {
            this.end = System.currentTimeMillis();
        }

        public long getDuration() {
            return this.end - this.start;
        }
    }
}

