/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.toolbar;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.widget.DataAdapterAction;
import com.jaspersoft.studio.data.widget.IDataAdapterRunnable;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.actions.RunStopAction;
import com.jaspersoft.studio.editor.preview.datasnapshot.DataSnapshotManager;
import com.jaspersoft.studio.editor.preview.datasnapshot.DatasnapshotDialog;
import com.jaspersoft.studio.editor.preview.datasnapshot.JSSColumnDataCacheHandler;
import com.jaspersoft.studio.editor.preview.toolbar.ATopToolBarManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.SimpleReportContext;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class PreviewTopToolBarManager
extends ATopToolBarManager {
    private ADataAdapterStorage[] adapters;
    private DataAdapterAction dataSourceWidget;
    private RunStopAction vexecAction;
    private Action iconAction;
    private IPropertyChangeListener prefListener = null;

    public PreviewTopToolBarManager(PreviewContainer container, Composite parent, ADataAdapterStorage[] adapters) {
        super(container, parent);
        this.dataSourceWidget.setDataAdapterStorages(adapters);
        this.adapters = adapters;
    }

    public void dispose() {
        JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.prefListener);
    }

    @Override
    protected void fillToolbar(IToolBarManager tbManager) {
        PreviewContainer pvcont = (PreviewContainer)this.container;
        if (this.iconAction == null) {
            this.iconAction = new IconAction();
        }
        tbManager.add((IAction)this.iconAction);
        if (this.dataSourceWidget == null) {
            this.dataSourceWidget = new DataAdapterAction((IDataAdapterRunnable)((Object)this.container), this.adapters);
            if (this.prefListener == null) {
                this.prefListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getProperty().equals("com.jaspersoft.studio.data.adapter.filter")) {
                            PreviewTopToolBarManager.this.refreshDataAdapters();
                        }
                    }
                };
            }
            JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.prefListener, (IResource)this.container.getJrContext().get("ifile"));
        }
        tbManager.add((IAction)this.dataSourceWidget);
        if (this.vexecAction == null) {
            this.vexecAction = new RunStopAction(pvcont);
        }
        tbManager.add((IAction)this.vexecAction);
    }

    public void refreshDataAdapters() {
        JasperReportsConfiguration jrContext = this.container.getJrContext();
        String filter = jrContext.getProperty("com.jaspersoft.studio.data.adapter.filter");
        if (filter != null && filter.equals("da") && jrContext.getJasperDesign() != null) {
            JRQuery q = jrContext.getJasperDesign().getQuery();
            this.dataSourceWidget.setLanguage(q != null ? q.getLanguage() : null);
        } else {
            this.dataSourceWidget.setLanguage(null);
        }
        if (!this.getTopToolBar().isDisposed()) {
            this.dataSourceWidget.getMenu((Control)this.getTopToolBar());
            this.dataSourceWidget.refreshDA();
        }
    }

    public DataAdapterAction getDataSourceWidget() {
        return this.dataSourceWidget;
    }

    public void setDataAdapters(String daName) {
        AEditorContext cntx = this.container.getJrContext().getEditorContext();
        ADataAdapterStorage[] aDataAdapterStorageArray = this.adapters;
        int n = this.adapters.length;
        int n2 = 0;
        while (n2 < n) {
            DataAdapterDescriptor descriptor;
            ADataAdapterStorage da = aDataAdapterStorageArray[n2];
            if (cntx.isDataAdapterStorage(da) && (descriptor = da.findDataAdapter(daName)) != null) {
                this.dataSourceWidget.setSelected(descriptor);
                break;
            }
            ++n2;
        }
    }

    class IconAction
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private MenuItem itemFilter;

        public IconAction() {
            this.setId("iconAction");
            this.setEnabled(true);
            this.setImageDescriptor(MDataAdapters.getIconDescriptor().getIcon16());
            this.setDisabledImageDescriptor(MDataAdapters.getIconDescriptor().getIcon16());
        }

        public boolean isEnabled() {
            return true;
        }

        public void runWithEvent(Event event) {
            if (PreviewTopToolBarManager.this.container.getJrContext().getEditorContext().supportsDataSnapshots()) {
                Point point = ((ToolItem)event.widget).getParent().toDisplay(new Point(event.x, event.y));
                this.menu = this.getMenu((Control)((ToolItem)event.widget).getParent());
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
            }
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(final Control parent) {
            JasperReportsConfiguration jrContext;
            String daFilter;
            if (this.menu == null) {
                this.menu = new Menu(parent);
                MenuItem itemDsOption = new MenuItem(this.menu, 8);
                itemDsOption.setText("Data Snapshot Options");
                UIUtil.safeApplyMenuItemTooltip(itemDsOption, "Setup data snapshot options.");
                itemDsOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new DatasnapshotDialog(parent.getShell(), ((IconAction)IconAction.this).PreviewTopToolBarManager.this.container.getJrContext()).open();
                    }
                });
                MenuItem itemLoad = new MenuItem(this.menu, 8);
                itemLoad.setText(Messages.PreviewTopToolBarManager_8);
                UIUtil.safeApplyMenuItemTooltip(itemLoad, "Load data snapshot from a file.");
                itemLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog fd = new FileDialog(parent.getShell(), 4096);
                        fd.setText(Messages.PreviewTopToolBarManager_9);
                        fd.setFilterExtensions(new String[]{"*.jrds", "*.*"});
                        String fname = fd.open();
                        if (fname != null) {
                            try {
                                DataSnapshotManager.loadSnapshot(((IconAction)IconAction.this).PreviewTopToolBarManager.this.container.getJrContext(), fname);
                                ((IconAction)IconAction.this).PreviewTopToolBarManager.this.container.getJrContext().getJasperDesign().setProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
                                ((IconAction)IconAction.this).PreviewTopToolBarManager.this.vexecAction.run();
                            }
                            catch (Exception e1) {
                                UIUtils.showError((Throwable)e1);
                            }
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                this.itemFilter = new MenuItem(this.menu, 32);
                this.itemFilter.setText("Filter Data Adapters By Report Language");
                UIUtil.safeApplyMenuItemTooltip(this.itemFilter, "If true, show only data adapters meaningful for the main dataset query language.");
                this.itemFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            JasperReportsConfiguration jrContext = ((IconAction)IconAction.this).PreviewTopToolBarManager.this.container.getJrContext();
                            jrContext.getPrefStore().setDefault("com.jaspersoft.studio.data.adapter.filter", "");
                            jrContext.getPrefStore().setValue("com.jaspersoft.studio.data.adapter.filter", IconAction.this.itemFilter.getSelection() ? "da" : "all");
                            jrContext.getPrefStore().save();
                        }
                        catch (IOException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                });
            }
            this.itemFilter.setSelection((daFilter = (jrContext = PreviewTopToolBarManager.this.container.getJrContext()).getPrefStore().getString("com.jaspersoft.studio.data.adapter.filter")) != null && daFilter.equals("da"));
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void doSelectDataSnapshotFile(Shell shell) {
            FileDialog fd = new FileDialog(shell, 8192);
            fd.setText(Messages.PreviewTopToolBarManager_3);
            String sname = "snapshot.jrds";
            IFile f = (IFile)PreviewTopToolBarManager.this.container.getJrContext().get("ifile");
            if (f != null) {
                sname = String.valueOf(FilenameUtils.getBaseName((String)f.getName())) + ".jrds";
            }
            fd.setFilterPath(f.getParent().getLocation().toOSString());
            fd.setFileName(sname);
            fd.setOverwrite(true);
            fd.setFilterExtensions(new String[]{"*.jrds", "*.*"});
            String fname = fd.open();
            Map<String, Object> hm = PreviewTopToolBarManager.this.container.getJrContext().getJRParameters();
            if (fname != null) {
                DataCacheHandler cacheHandler = DataSnapshotManager.setDataSnapshot(hm, false);
                if (cacheHandler.getDataSnapshot() != null) {
                    Date creationTimestamp = new Date();
                    if (cacheHandler instanceof JSSColumnDataCacheHandler) {
                        creationTimestamp = ((JSSColumnDataCacheHandler)cacheHandler).getCreationTimestamp();
                    }
                    DataSnapshotManager.saveSnapshot(fname, creationTimestamp, cacheHandler.getDataSnapshot());
                }
                SimpleReportContext reportContext = (SimpleReportContext)hm.get("REPORT_CONTEXT");
                reportContext.setParameterValue("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", (Object)fname);
                PreviewTopToolBarManager.this.container.getJrContext().getMap().put("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
                PreviewTopToolBarManager.this.container.getJrContext().getJasperDesign().setProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT", fname);
            }
        }
    }
}

