/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.file;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.report.IURLViewable;
import com.jaspersoft.studio.editor.preview.view.report.html.URLContributionItem;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextFileViewer
extends APreview
implements IURLViewable {
    protected StyledText browser;
    protected String url;
    private URLContributionItem urlBar;

    public TextFileViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        try {
            this.browser = new StyledText(composite, 72);
            this.browser.setLayoutData((Object)new GridData(1808));
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return composite;
    }

    @Override
    public void contribute2ToolBar(IToolBarManager tmanager) {
        super.contribute2ToolBar(tmanager);
        this.urlBar = new URLContributionItem(Misc.nvl((Object)this.url, (String)" "));
        tmanager.add((IContributionItem)this.urlBar);
        tmanager.add((IAction)new Action("", JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/refresh-16.png")){

            public void run() {
                try {
                    TextFileViewer.this.showData(TextFileViewer.this.url);
                }
                catch (MalformedURLException e) {
                    UIUtils.showError((Throwable)e);
                }
                catch (IOException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
        });
    }

    public void setURL(String url, String urlcookie, String scookie) throws Exception {
        this.url = Misc.nvl((String)url);
        if (this.urlBar != null) {
            this.urlBar.setUrl(url);
        }
        if (this.browser != null) {
            this.showData(url);
        }
    }

    protected void showData(String url) throws IOException, MalformedURLException {
        InputStream in = new URL(url).openStream();
        try {
            this.browser.setText(IOUtils.toString((InputStream)in));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void setURL(String url) throws Exception {
        this.setURL(url, null, null);
    }
}

