/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.editor.report.SelectionChangedListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CommonSelectionCacheProvider {
    private Map<Class<?>, ModelPartPair> cachedModelTypedRequest = new HashMap();
    private Map<Class<?>, List<Object>> cachedEditPartTypedRequest = new HashMap();
    private ModelPartPair lastModelSelection = new ModelPartPair();
    private List<Object> lastEditPartSelection = new ArrayList<Object>();
    private List<SelectionChangedListener> selectionChangeListeners = new ArrayList<SelectionChangedListener>();
    public boolean allowDishomogeneousSelection = false;
    private ISelection lastSelection = null;

    private ModelPartPair createCacheForModelType(Class<?> type) {
        ModelPartPair result = new ModelPartPair();
        for (EditPart part : this.lastModelSelection.parts) {
            if (type.isInstance(part.getModel())) {
                result.add(part);
                continue;
            }
            if (this.allowDishomogeneousSelection) continue;
            return new ModelPartPair();
        }
        return result;
    }

    private List<Object> createCacheForEditPartType(Class<?> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : this.lastEditPartSelection) {
            if (type.isInstance(obj)) {
                result.add(obj);
                continue;
            }
            if (this.allowDishomogeneousSelection) continue;
            return new ArrayList<Object>();
        }
        return result;
    }

    public List<Object> getSelectionModelForType(Class<?> type) {
        ModelPartPair cachedValue = this.cachedModelTypedRequest.get(type);
        if (cachedValue == null) {
            cachedValue = this.createCacheForModelType(type);
            this.cachedModelTypedRequest.put(type, cachedValue);
        }
        return cachedValue.models;
    }

    public List<EditPart> getSelectionModelPartForType(Class<?> type) {
        ModelPartPair cachedValue = this.cachedModelTypedRequest.get(type);
        if (cachedValue == null) {
            cachedValue = this.createCacheForModelType(type);
            this.cachedModelTypedRequest.put(type, cachedValue);
        }
        return cachedValue.parts;
    }

    public List<Object> getSelectionPartForType(Class<?> type) {
        List<Object> cachedValue = this.cachedEditPartTypedRequest.get(type);
        if (cachedValue == null) {
            cachedValue = this.createCacheForEditPartType(type);
            this.cachedEditPartTypedRequest.put(type, cachedValue);
        }
        return cachedValue;
    }

    private void reinitializeMaps() {
        this.lastModelSelection.clear();
        this.cachedModelTypedRequest.clear();
        this.lastEditPartSelection.clear();
        this.cachedEditPartTypedRequest.clear();
        IStructuredSelection sSel = (IStructuredSelection)this.lastSelection;
        if (sSel != null) {
            for (Object obj : sSel) {
                if (!(obj instanceof EditPart)) continue;
                EditPart editPart = (EditPart)obj;
                this.lastModelSelection.add(editPart);
                this.lastEditPartSelection.add(editPart);
            }
        }
    }

    public void setAllowingDishomogeneousSelection(boolean isAllowed) {
        if (this.allowDishomogeneousSelection != isAllowed) {
            this.allowDishomogeneousSelection = isAllowed;
            this.reinitializeMaps();
        }
    }

    public ISelection getLastRawSelection() {
        return this.lastSelection;
    }

    public void selectionChanged(ISelection selection) {
        if (selection == null) {
            return;
        }
        if (!selection.equals(this.lastSelection) && selection instanceof IStructuredSelection) {
            this.lastSelection = selection;
            this.reinitializeMaps();
            for (SelectionChangedListener listener : this.selectionChangeListeners) {
                listener.selectionChanged();
            }
        }
    }

    public boolean addSelectionChangeListener(SelectionChangedListener listener) {
        if (!this.selectionChangeListeners.contains(listener)) {
            this.selectionChangeListeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeSelectionChangeListener(SelectionChangedListener listener) {
        return this.selectionChangeListeners.remove(listener);
    }

    public class ModelPartPair {
        private List<Object> models = new ArrayList<Object>();
        private List<EditPart> parts = new ArrayList<EditPart>();

        public void add(EditPart part) {
            this.models.add(part.getModel());
            this.parts.add(part);
        }

        public void clear() {
            this.models.clear();
            this.parts.clear();
        }
    }
}

