/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.java2d.ISelectionOverrider;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import com.jaspersoft.studio.utils.compatibility.FigureUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class MarqueeSelectionOverrider
implements ISelectionOverrider {
    private static final String BINDING_KEY_ID = "com.jaspersoft.studio.editor.MarqueeSelectionOverrider";

    protected Collection<EditPart> calculatePrimaryMarqueeSelectedEditParts(GraphicalViewer viewer, Rectangle selectionRectangle, boolean allowNotFullyClipped) {
        HashSet editPartsToProcess = new HashSet();
        editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)((GraphicalEditPart)viewer.getRootEditPart())));
        ArrayList<EditPart> marqueeSelectedEditParts = new ArrayList<EditPart>();
        for (GraphicalEditPart editPart : editPartsToProcess) {
            if (!this.isMarqueeSelectable(editPart, allowNotFullyClipped) || !this.isPrimaryMarqueeSelectedEditPart(editPart, selectionRectangle)) continue;
            marqueeSelectedEditParts.add((EditPart)editPart);
        }
        return marqueeSelectedEditParts;
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart, boolean allowNotFullyClipped) {
        if (editPart.isSelectable() && editPart.getModel() instanceof MGraphicElement) {
            if (allowNotFullyClipped) {
                return true;
            }
            return FigureUtilities.isNotFullyClipped(editPart.getFigure());
        }
        return false;
    }

    private boolean isPrimaryMarqueeSelectedEditPart(GraphicalEditPart editPart, Rectangle selectionRectangle) {
        IFigure figure = editPart.getFigure();
        Rectangle r = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)r);
        return selectionRectangle.contains(r);
    }

    @Override
    public boolean overriddenSelection(EditPart selectedPart, List<?> previousSelection, GraphicalViewer currentViewer) {
        if (selectedPart != null && BindingsPreferencePersistence.isPressed(BINDING_KEY_ID)) {
            ArrayList<GraphicalEditPart> graphicalParts = new ArrayList<GraphicalEditPart>();
            for (Object currentPart : previousSelection) {
                if (!(currentPart instanceof GraphicalEditPart) || currentPart instanceof BandEditPart) continue;
                graphicalParts.add((GraphicalEditPart)currentPart);
            }
            if (selectedPart instanceof GraphicalEditPart && !(selectedPart instanceof BandEditPart)) {
                graphicalParts.add((GraphicalEditPart)selectedPart);
            }
            if (graphicalParts.size() > 1) {
                IFigure figure = ((GraphicalEditPart)graphicalParts.get(0)).getFigure();
                Rectangle containerRectangle = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)containerRectangle);
                for (GraphicalEditPart graphicPart : graphicalParts) {
                    int delta;
                    figure = graphicPart.getFigure();
                    Rectangle r = figure.getBounds().getCopy();
                    figure.translateToAbsolute((Translatable)r);
                    if (r.x + r.width > containerRectangle.x + containerRectangle.width) {
                        delta = r.x + r.width - containerRectangle.x - containerRectangle.width;
                        containerRectangle.width += delta;
                    }
                    if (r.x < containerRectangle.x) {
                        delta = containerRectangle.x - r.x;
                        containerRectangle.x = r.x;
                        containerRectangle.width += delta;
                    }
                    if (r.y + r.height > containerRectangle.y + containerRectangle.height) {
                        delta = r.y + r.height - containerRectangle.y - containerRectangle.height;
                        containerRectangle.height += delta;
                    }
                    if (r.y >= containerRectangle.y) continue;
                    delta = containerRectangle.y - r.y;
                    containerRectangle.y = r.y;
                    containerRectangle.height += delta;
                }
                Collection<EditPart> partsToSelect = this.calculatePrimaryMarqueeSelectedEditParts(currentViewer, containerRectangle, true);
                currentViewer.setSelection((ISelection)new StructuredSelection(new ArrayList<EditPart>(partsToSelect)));
                return true;
            }
        }
        return false;
    }
}

