/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.events.KeyEvent;

public class MovableSelectionTool
extends SelectionTool {
    protected boolean handleKeyDown(KeyEvent e) {
        EditPartViewer viewer;
        if (this.isInState(1) && UIUtil.isArrowKey(e.keyCode) && (viewer = this.getCurrentViewer()) instanceof GraphicalViewer) {
            JSSCompoundCommand ccmd = new JSSCompoundCommand(null);
            for (Object selectedEditPart : this.getCurrentViewer().getSelectedEditParts()) {
                Object modelObj;
                if (!(selectedEditPart instanceof GraphicalEditPart) || !((modelObj = ((EditPart)selectedEditPart).getModel()) instanceof MGraphicElement)) continue;
                MGraphicElement node = (MGraphicElement)modelObj;
                ccmd.add(this.getNewXYCommand(e.keyCode, node));
            }
            if (!ccmd.isEmpty()) {
                this.getDomain().getCommandStack().execute((Command)ccmd);
                return true;
            }
        }
        return super.handleKeyDown(e);
    }

    private Command getNewXYCommand(int arrowKeyCode, MGraphicElement node) {
        int step = 1;
        if (JasperReportsPlugin.isPressed((int)131072)) {
            step = 10;
        }
        Integer x = (Integer)node.getPropertyValue("x");
        Integer y = (Integer)node.getPropertyValue("y");
        SetValueCommand newXYCmd = new SetValueCommand();
        newXYCmd.setTarget(node);
        switch (arrowKeyCode) {
            case 0x1000001: {
                newXYCmd.setPropertyId("y");
                newXYCmd.setPropertyValue(y - step);
                break;
            }
            case 0x1000002: {
                newXYCmd.setPropertyId("y");
                newXYCmd.setPropertyValue(y + step);
                break;
            }
            case 0x1000003: {
                newXYCmd.setPropertyId("x");
                newXYCmd.setPropertyValue(x - step);
                break;
            }
            case 0x1000004: {
                newXYCmd.setPropertyId("x");
                newXYCmd.setPropertyValue(x + step);
                break;
            }
            default: {
                throw new RuntimeException("Only arrow keys can be accepted!");
            }
        }
        return newXYCmd;
    }
}

