/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.CompileAction;
import com.jaspersoft.studio.editor.gef.parts.JSSGraphicalViewerKeyHandler;
import com.jaspersoft.studio.editor.gef.parts.JasperDesignEditPartFactory;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerProvider;
import com.jaspersoft.studio.editor.gef.ui.actions.RZoomComboContributionItem;
import com.jaspersoft.studio.editor.gef.ui.actions.ViewSettingsDropDownAction;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.outline.JDReportOutlineView;
import com.jaspersoft.studio.editor.outline.actions.CreateBandAction;
import com.jaspersoft.studio.editor.outline.actions.CreateDetailBandAction;
import com.jaspersoft.studio.editor.outline.actions.CreateDetailBandActionOnDetail;
import com.jaspersoft.studio.editor.outline.actions.CreateGroupFooterAction;
import com.jaspersoft.studio.editor.outline.actions.CreateGroupHeaderAction;
import com.jaspersoft.studio.editor.outline.actions.DeleteGroupReportAction;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.MarqueeSelectionOverrider;
import com.jaspersoft.studio.editor.report.ParentSelectionOverrider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.property.dataset.dialog.ContextualDatasetAction;
import com.jaspersoft.studio.property.dataset.dialog.DatasetAction;
import com.jaspersoft.studio.property.section.report.action.PageFormatAction;
import com.jaspersoft.studio.property.section.report.action.PageRemoveMarginsAction;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.WorkbenchPart;

public class ReportEditor
extends AbstractVisualEditor {
    public static final String ID = ReportEditor.class.getName();

    public ReportEditor(JasperReportsConfiguration jrContext) {
        super(jrContext);
        this.setPartName(Messages.common_main_report);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.button);
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setEditPartFactory((EditPartFactory)new JasperDesignEditPartFactory());
        ReportRulerProvider provider = new ReportRulerProvider(new ReportRuler(true, 2));
        graphicalViewer.setProperty("horizontal ruler", (Object)provider);
        provider = new ReportRulerProvider(new ReportRuler(false, 2));
        graphicalViewer.setProperty("vertical ruler", (Object)provider);
        Boolean isRulerVisible = this.jrContext.getPropertyBoolean("pageRulerGrid_SHOWRULER");
        graphicalViewer.setProperty("ruler$visibility", (Object)isRulerVisible);
        this.createAdditionalActions();
        graphicalViewer.setKeyHandler((KeyHandler)new JSSGraphicalViewerKeyHandler(graphicalViewer));
        if (graphicalViewer instanceof JSSScrollingGraphicalViewer) {
            JSSScrollingGraphicalViewer jssViewer = (JSSScrollingGraphicalViewer)graphicalViewer;
            jssViewer.addSelectionOverrider(new ParentSelectionOverrider(IContainer.class, true));
            jssViewer.addSelectionOverrider(new MarqueeSelectionOverrider());
        }
    }

    @Override
    protected List<String> getIgnorePalleteElements() {
        return null;
    }

    @Override
    protected JDReportOutlineView getOutlineView() {
        if (this.outlinePage == null || this.outlinePage.isDisposed()) {
            TreeViewer viewer = new TreeViewer();
            this.outlinePage = new JDReportOutlineView(this, (EditPartViewer)viewer){

                @Override
                protected void initActions(ActionRegistry registry, IActionBars bars) {
                    String id = "delete_group_report";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_variables";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_parameters";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_fields";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "showfieldstree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "deleteFieldsGroupTree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "deleteFieldsGroupAllTree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "hide_default_parameters";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "hide_default_variables";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_field";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_fieldscontainer";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_sort_field";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_variable";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_scriptlet";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_parameter";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_parameter_set";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_group";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_dataset";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_style";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_conditional_style";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "export_style_as_template";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "refresh_template_style_expression";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "refresh_template_style_reference";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "reset_style_properites";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_style_template";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_band";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_detail_band";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_detail_band_on_detail";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "pageFormatAction";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "pageRemoveMarginsAction";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "datasetAction";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "compileAction";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                }
            };
        }
        return this.outlinePage;
    }

    @Override
    protected void createEditorActions(ActionRegistry registry) {
        List selectionActions = this.getSelectionActions();
        this.createDatasetAndStyleActions(registry);
        Object action = new CreateBandAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_band");
        action = new CreateDetailBandAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_detail_band");
        action = new CreateDetailBandActionOnDetail((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_detail_band_on_detail");
        action = new CreateGroupHeaderAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_group_header_band");
        action = new CreateGroupFooterAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_group_footer_band");
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        List<Action> lst = m.getActions((WorkbenchPart)this);
        for (Action act : lst) {
            action = act;
            registry.registerAction((IAction)action);
            selectionActions.add(act.getId());
        }
        action = new DeleteGroupReportAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("delete_group_report");
        action = new PageFormatAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PageRemoveMarginsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new ContextualDatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CompileAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    @Override
    public void contributeItemsToEditorTopToolbar(IToolBarManager toolbarManager) {
        GraphicalViewer graphicalViewer;
        ZoomManager property;
        this.topToolbarManager = toolbarManager;
        ActionContributionItem item = new ActionContributionItem(this.getActionRegistry().getAction((Object)"datasetAction"));
        this.act4TextIcon.add(item);
        toolbarManager.add((IContributionItem)item);
        item = new ActionContributionItem(this.getActionRegistry().getAction((Object)"compileAction"));
        this.act4TextIcon.add(item);
        toolbarManager.add((IContributionItem)item);
        List<AContributorAction> contributedActions = JaspersoftStudioPlugin.getExtensionManager().getActions();
        for (AContributorAction a : contributedActions) {
            a.setJrConfig((JasperReportsConfiguration)((Object)this.getGraphicalViewer().getProperty("JRCONTEXT")));
            item = new ActionContributionItem((IAction)a);
            this.act4TextIcon.add(item);
            toolbarManager.add((IContributionItem)item);
        }
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        toolbarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        if (this.zoomItem != null) {
            this.zoomItem.dispose();
            this.zoomItem = null;
        }
        if ((property = (ZoomManager)(graphicalViewer = this.getGraphicalViewer()).getProperty(ZoomManager.class.toString())) != null) {
            this.zoomItem = new RZoomComboContributionItem(property);
            toolbarManager.add((IContributionItem)this.zoomItem);
        }
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new ViewSettingsDropDownAction(this.getActionRegistry()));
        this.setTextIcon();
    }
}

