/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.CustomDeleteAction;
import com.jaspersoft.studio.editor.action.copy.AbstractPastableObject;
import com.jaspersoft.studio.editor.action.copy.PasteAction;
import com.jaspersoft.studio.editor.gef.parts.JSSGraphicalViewerKeyHandler;
import com.jaspersoft.studio.editor.gef.parts.JasperDesignEditPartFactory;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerProvider;
import com.jaspersoft.studio.editor.gef.ui.actions.RZoomComboContributionItem;
import com.jaspersoft.studio.editor.gef.ui.actions.ViewSettingsDropDownAction;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.outline.JDReportOutlineView;
import com.jaspersoft.studio.editor.palette.JDPaletteFactory;
import com.jaspersoft.studio.editor.report.MarqueeSelectionOverrider;
import com.jaspersoft.studio.editor.report.ParentSelectionOverrider;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.property.section.report.action.PageFormatAction;
import com.jaspersoft.studio.property.section.report.action.PageRemoveMarginsAction;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.WorkbenchPart;

public class SimpleReportEditor
extends ReportEditor {
    public static final String ID = SimpleReportEditor.class.getName();

    public SimpleReportEditor(JasperReportsConfiguration jrContext) {
        super(jrContext);
        this.setPartName(Messages.common_main_report);
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.button);
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setEditPartFactory((EditPartFactory)new JasperDesignEditPartFactory());
        ReportRulerProvider provider = new ReportRulerProvider(new ReportRuler(true, 2));
        graphicalViewer.setProperty("horizontal ruler", (Object)provider);
        provider = new ReportRulerProvider(new ReportRuler(false, 2));
        graphicalViewer.setProperty("vertical ruler", (Object)provider);
        Boolean isRulerVisible = this.jrContext.getPropertyBoolean("pageRulerGrid_SHOWRULER");
        graphicalViewer.setProperty("ruler$visibility", (Object)isRulerVisible);
        this.createAdditionalActions();
        graphicalViewer.setKeyHandler((KeyHandler)new JSSGraphicalViewerKeyHandler(graphicalViewer));
        if (graphicalViewer instanceof JSSScrollingGraphicalViewer) {
            JSSScrollingGraphicalViewer jssViewer = (JSSScrollingGraphicalViewer)graphicalViewer;
            jssViewer.addSelectionOverrider(new ParentSelectionOverrider(IContainer.class, true));
            jssViewer.addSelectionOverrider(new MarqueeSelectionOverrider());
        }
    }

    @Override
    protected PaletteRoot getPaletteRoot() {
        return JDPaletteFactory.createSimplePalette(this.getIgnorePalleteElements(), this.jrContext);
    }

    @Override
    protected JDReportOutlineView getOutlineView() {
        if (this.outlinePage == null || this.outlinePage.isDisposed()) {
            TreeViewer viewer = new TreeViewer();
            this.outlinePage = new JDReportOutlineView(this, (EditPartViewer)viewer){

                @Override
                protected void initActions(ActionRegistry registry, IActionBars bars) {
                    String id = "delete_group_report";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_variables";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_parameters";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "sort_fields";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "showfieldstree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "deleteFieldsGroupTree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "deleteFieldsGroupAllTree";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "hide_default_parameters";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "hide_default_variables";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_field";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_fieldscontainer";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_sort_field";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_variable";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_parameter";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                    id = "create_parameter_set";
                    bars.setGlobalActionHandler(id, registry.getAction((Object)id));
                }
            };
        }
        return this.outlinePage;
    }

    @Override
    protected void createEditorActions(ActionRegistry registry) {
        List selectionActions = this.getSelectionActions();
        ACachedSelectionAction action = null;
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        List<Action> lst = m.getActions((WorkbenchPart)this);
        for (Action act : lst) {
            action = act;
            registry.registerAction((IAction)action);
            selectionActions.add(act.getId());
        }
        action = new PageFormatAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PageRemoveMarginsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        CustomDeleteAction deleteAction = new CustomDeleteAction((IWorkbenchPart)this){

            private boolean isBandOrReportSelected() {
                List objects = this.getSelectedObjects();
                if (objects.isEmpty()) {
                    return false;
                }
                if (!(objects.get(0) instanceof EditPart)) {
                    return false;
                }
                int i = 0;
                while (i < objects.size()) {
                    EditPart object = (EditPart)objects.get(i);
                    if (object.getModel() instanceof MBand || object.getModel() instanceof MReport) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public boolean isEnabled() {
                return !this.isBandOrReportSelected();
            }
        };
        registry.registerAction((IAction)deleteAction);
    }

    @Override
    public void contributeItemsToEditorTopToolbar(IToolBarManager toolbarManager) {
        GraphicalViewer graphicalViewer;
        ZoomManager property;
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        toolbarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        if (this.zoomItem != null) {
            this.zoomItem.dispose();
            this.zoomItem = null;
        }
        if ((property = (ZoomManager)(graphicalViewer = this.getGraphicalViewer()).getProperty(ZoomManager.class.toString())) != null) {
            this.zoomItem = new RZoomComboContributionItem(property);
            toolbarManager.add((IContributionItem)this.zoomItem);
        }
        toolbarManager.add((IContributionItem)new Separator());
        List<AContributorAction> contributedActions = JaspersoftStudioPlugin.getExtensionManager().getActions();
        for (AContributorAction a : contributedActions) {
            a.setJrConfig((JasperReportsConfiguration)((Object)this.getGraphicalViewer().getProperty("JRCONTEXT")));
            toolbarManager.add((IAction)a);
        }
        toolbarManager.add((IAction)new ViewSettingsDropDownAction(this.getActionRegistry()));
    }

    @Override
    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        PasteAction action = new PasteAction((IWorkbenchPart)this){

            protected boolean checkDataset(INode currentNode) {
                if (currentNode instanceof IDatasetContainer) {
                    return true;
                }
                for (INode child : currentNode.getChildren()) {
                    if (!this.checkDataset(child)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected boolean calculateEnabled() {
                Object obj = Clipboard.getDefault().getContents();
                if (obj instanceof AbstractPastableObject) {
                    AbstractPastableObject pastableContainer = (AbstractPastableObject)obj;
                    for (ICopyable node : pastableContainer.getCopiedElements()) {
                        boolean hasDataset;
                        if (!(node instanceof INode) || !(hasDataset = this.checkDataset((INode)((Object)node)))) continue;
                        return false;
                    }
                }
                return super.calculateEnabled();
            }
        };
        registry.registerAction((IAction)action);
    }
}

