/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style;

import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class TemplateStyle
implements Serializable {
    private static final long serialVersionUID = -7918944412275638526L;
    public static final String DESCRIPTION_KEY = "style_description";
    protected AlfaRGB baseColor;
    protected ColorSchemaGenerator.SCHEMAS variation;
    private HashMap<String, AlfaRGB> storedColor;
    private HashMap<String, Object> storedProperties;

    public TemplateStyle(AlfaRGB baseColor, ColorSchemaGenerator.SCHEMAS variation) {
        this.baseColor = baseColor;
        this.variation = variation;
        this.storedProperties = new HashMap();
        this.storedColor = new HashMap();
    }

    public AlfaRGB getBaseColor() {
        return this.baseColor;
    }

    public ColorSchemaGenerator.SCHEMAS getVariation() {
        return this.variation;
    }

    public List<String> getStoredPropertiesName() {
        return new ArrayList<String>(this.storedProperties.keySet());
    }

    public List<String> getStoredColorsName() {
        return new ArrayList<String>(this.storedColor.keySet());
    }

    public void storeColor(String name, AlfaRGB color) {
        this.storedColor.put(name, color);
    }

    public AlfaRGB generateAndStoreColor(String name, int gradation) {
        AlfaRGB generatedColor = ColorSchemaGenerator.createColor(this.baseColor, gradation, this.variation);
        this.storedColor.put(name, generatedColor);
        return generatedColor;
    }

    public AlfaRGB generateColor(int gradation) {
        AlfaRGB generatedColor = ColorSchemaGenerator.createColor(this.baseColor, gradation, this.variation);
        return generatedColor;
    }

    public void storePropertiy(String name, Object value) {
        this.storedProperties.put(name, value);
    }

    public Class<?> getPropertyType(String name) {
        if (this.storedProperties.containsKey(name)) {
            return this.storedProperties.get(name).getClass();
        }
        return null;
    }

    public boolean hasProperty(String name) {
        return this.storedProperties.containsKey(name);
    }

    public boolean hasColor(String name) {
        return this.storedColor.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.storedProperties.get(name);
    }

    public AlfaRGB getColor(String name) {
        return this.storedColor.get(name);
    }

    public void setDescription(String description) {
        this.storedProperties.put(DESCRIPTION_KEY, description);
    }

    public String getDescription() {
        Object value = this.storedProperties.get(DESCRIPTION_KEY);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static String xmlColor(String tagName, AlfaRGB color) {
        RGB rgbColor = color.getRgb();
        String colorString = "<".concat(tagName).concat(" r=\"");
        colorString = String.valueOf(colorString) + rgbColor.red;
        colorString = colorString.concat("\" g=\"");
        colorString = String.valueOf(colorString) + rgbColor.green;
        colorString = colorString.concat("\" b=\"");
        colorString = String.valueOf(colorString) + rgbColor.blue;
        colorString = colorString.concat("\" alpha=\"");
        colorString = String.valueOf(colorString) + color.getAlfa();
        colorString = colorString.concat("\"/>");
        return colorString;
    }

    public static AlfaRGB rgbColor(Node xmlColorNode) {
        NamedNodeMap colorAttributes = xmlColorNode.getAttributes();
        int r = Integer.parseInt(colorAttributes.getNamedItem("r").getNodeValue());
        int g = Integer.parseInt(colorAttributes.getNamedItem("g").getNodeValue());
        int b = Integer.parseInt(colorAttributes.getNamedItem("b").getNodeValue());
        int alpha = Integer.parseInt(colorAttributes.getNamedItem("alpha").getNodeValue());
        return new AlfaRGB(new RGB(r, g, b), alpha);
    }

    protected static LineStyleEnum getLineStyleFromValue(Object value) {
        if (value instanceof String) {
            String v = (String)value;
            LineStyleEnum[] lineStyleEnumArray = LineStyleEnum.values();
            int n = lineStyleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineStyleEnum en = lineStyleEnumArray[n2];
                if (en.getName().equals(v)) {
                    return en;
                }
                ++n2;
            }
        }
        return LineStyleEnum.SOLID;
    }

    protected static VerticalTextAlignEnum getTextVAlignmentFromValue(Object value) {
        if (value instanceof String) {
            String v = (String)value;
            VerticalTextAlignEnum[] verticalTextAlignEnumArray = VerticalTextAlignEnum.values();
            int n = verticalTextAlignEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                VerticalTextAlignEnum en = verticalTextAlignEnumArray[n2];
                if (en.getName().equals(v)) {
                    return en;
                }
                ++n2;
            }
        }
        return VerticalTextAlignEnum.TOP;
    }

    protected static HorizontalTextAlignEnum getTextHAlignmentFromValue(Object value) {
        if (value instanceof String) {
            String v = (String)value;
            HorizontalTextAlignEnum[] horizontalTextAlignEnumArray = HorizontalTextAlignEnum.values();
            int n = horizontalTextAlignEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                HorizontalTextAlignEnum en = horizontalTextAlignEnumArray[n2];
                if (en.getName().equals(v)) {
                    return en;
                }
                ++n2;
            }
        }
        return HorizontalTextAlignEnum.LEFT;
    }

    protected static RotationEnum getRotationFromValue(Object value) {
        if (value instanceof String) {
            String v = (String)value;
            RotationEnum[] rotationEnumArray = RotationEnum.values();
            int n = rotationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                RotationEnum en = rotationEnumArray[n2];
                if (en.getName().equals(v)) {
                    return en;
                }
                ++n2;
            }
        }
        return RotationEnum.NONE;
    }

    protected HashMap<String, TemplateStyle> getExistingStyles(String styleDescriptor) {
        HashMap<String, TemplateStyle> result = new HashMap<String, TemplateStyle>();
        Collection<TemplateStyle> styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(styleDescriptor);
        for (TemplateStyle style : styles) {
            result.put(style.getDescription(), style);
        }
        return result;
    }

    public abstract String getXMLData();

    public abstract String getTemplateName();

    public abstract TemplateStyle buildFromXML(Node var1);
}

