/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style.editpolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.create.CreateElementAction;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.style.StyleTreeEditPartFactory;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.TreeContainerEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class JDStyleTreeContainerEditPolicy
extends TreeContainerEditPolicy {
    protected Command createCreateCommand(ANode child, int index) {
        return StyleTreeEditPartFactory.getCreateCommand((ANode)this.getHost().getModel(), child, new Rectangle(0, 0, 0, 0), index);
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        List editparts = request.getEditParts();
        int index = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            EditPart child = (EditPart)editparts.get(i);
            command.setReferenceNodeIfNull(child.getModel());
            if (this.isAncestor(child, this.getHost())) {
                command.add((Command)UnexecutableCommand.INSTANCE);
            } else {
                ANode childModel = (ANode)child.getModel();
                command.add(this.createCreateCommand(childModel, index));
            }
            ++i;
        }
        return command;
    }

    protected Command getCreateCommand(CreateRequest request) {
        int index = this.findIndexOfTreeItemAt(request.getLocation());
        if (request.getNewObject() instanceof ANode) {
            return this.createCreateCommand((ANode)request.getNewObject(), index);
        }
        if (request.getNewObject() instanceof CreateElementAction) {
            CreateElementAction action = (CreateElementAction)((Object)request.getNewObject());
            action.dropInto(this.getHost().getModel(), new Rectangle(), index);
            action.run();
            return action.getCommand();
        }
        return null;
    }

    protected Command getMoveChildrenCommand(ChangeBoundsRequest request) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        List editparts = request.getEditParts();
        List children = this.getHost().getChildren();
        int newIndex = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            EditPart child = (EditPart)editparts.get(i);
            command.setReferenceNodeIfNull(child.getModel());
            int tempIndex = newIndex;
            int oldIndex = children.indexOf(child);
            if (oldIndex == tempIndex || oldIndex + 1 == tempIndex) {
                command.add((Command)UnexecutableCommand.INSTANCE);
                return command;
            }
            if (oldIndex <= tempIndex) {
                --tempIndex;
            }
            command.add(OutlineTreeEditPartFactory.getReorderCommand((ANode)child.getModel(), (ANode)this.getHost().getModel(), tempIndex));
            ++i;
        }
        return command;
    }

    protected boolean isAncestor(EditPart source, EditPart target) {
        ANode targetModel = (ANode)target.getModel();
        return targetModel.getValue() == null;
    }
}

