/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style.wizard;

import com.jaspersoft.studio.editor.style.wizard.StyleTemplateNewWizard;
import com.jaspersoft.studio.editor.style.wizard.WizardHelpNewFileCreationPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class StyleTemplateExportWizard
extends StyleTemplateNewWizard {
    private List<JRStyle> stylesToImport;

    public StyleTemplateExportWizard(List<JRStyle> stylesToImport) {
        this.stylesToImport = stylesToImport;
    }

    @Override
    protected InputStream openContentStream() {
        JasperReportsConfiguration jConf = null;
        try {
            JRSimpleTemplate tmp = new JRSimpleTemplate();
            if (this.stylesToImport == null || this.stylesToImport.isEmpty()) {
                JRDesignStyle jrDesignStyle = new JRDesignStyle();
                jrDesignStyle.setName("SimpleStyle");
                tmp.addStyle((JRStyle)jrDesignStyle);
            } else {
                for (JRStyle style : this.stylesToImport) {
                    tmp.addStyle(style);
                }
            }
            jConf = this.file != null ? JasperReportsConfiguration.getDefaultJRConfig(this.file) : (this.reportFile != null ? JasperReportsConfiguration.getDefaultJRConfig(this.reportFile) : JasperReportsConfiguration.getDefaultJRConfig());
            jConf.setProperty("net.sf.jasperreports.report.version", jConf.getProperty("com.jaspersoft.studio.compatibility.version"));
            String contents = JRXmlTemplateWriter.writeTemplate((JasperReportsContext)jConf, (JRTemplate)tmp);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents.getBytes());
            return byteArrayInputStream;
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        finally {
            jConf.dispose();
        }
        return null;
    }

    protected boolean hasConditionalStyles() {
        for (JRStyle style : this.stylesToImport) {
            if (style.getConditionalStyles().length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void openEditor(IFile file) {
    }

    public void openStyleEditor() {
        if (this.getReportFile() != null) {
            super.openEditor(this.getReportFile());
        }
    }

    @Override
    protected WizardNewFileCreationPage getDestinationPage() {
        WizardHelpNewFileCreationPage page = new WizardHelpNewFileCreationPage("newFilePage1", (IStructuredSelection)this.selection){

            protected boolean validatePage() {
                boolean isValid = super.validatePage();
                if (isValid) {
                    if (StyleTemplateExportWizard.this.hasConditionalStyles()) {
                        StyleTemplateExportWizard.this.step1.setMessage(Messages.StyleTemplateExportWizard_conditionalStyleWarning, 2);
                    } else {
                        StyleTemplateExportWizard.this.step1.setMessage(Messages.StyleTemplateImportWizard_description);
                    }
                }
                return isValid;
            }
        };
        page.setTitle(Messages.StyleTemplateImportWizard_title);
        page.setMessage(Messages.StyleTemplateImportWizard_description);
        page.setFileExtension("jrtx");
        return page;
    }
}

