/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.CompositeElementTemplateCreationEntry;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementsExportWizard;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.io.IOException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.ZipUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;

public class ExportCompositeElementAction
extends Action {
    private CompositeElementTemplateCreationEntry elementToExport;

    public ExportCompositeElementAction(CompositeElementTemplateCreationEntry elementToDelete) {
        this.setText(Messages.ExportCompositeElementAction_actionName);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/export.png"));
        this.elementToExport = elementToDelete;
    }

    public void run() {
        String destinationPath;
        MCompositeElement element = this.elementToExport.getTemplate();
        CompositeElementsExportWizard wizard = new CompositeElementsExportWizard(element);
        WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
        dialog.setPageSize(200, 200);
        if (dialog.open() == 0 && (destinationPath = this.getDestinationPath(element)) != null) {
            File destinationFile = new File(destinationPath);
            if (destinationFile.exists()) {
                boolean overwrite = UIUtils.showConfirmation((String)Messages.ExportCompositeElementAction_fileExistTitle, (String)Messages.ExportCompositeElementAction_fileExistDescription);
                if (overwrite) {
                    destinationFile.delete();
                } else {
                    return;
                }
            }
            File tempFolder = this.createTempFolder();
            CompositeElementManager.INSTANCE.exportCompositeElement(wizard.getSelectedElements(), tempFolder);
            ZipUtils zipUtils = new ZipUtils();
            zipUtils.zipFolderContent(tempFolder.getAbsolutePath(), destinationPath);
            try {
                FileUtils.deleteDirectory((File)tempFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEnabled() {
        return this.elementToExport != null;
    }

    private String getDestinationPath(MCompositeElement element) {
        FileDialog dialog = new FileDialog(UIUtils.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFilterPath(System.getProperty("user.home"));
        dialog.setFileName(String.valueOf(element.getName()) + ".zip");
        return dialog.open();
    }

    private File createTempFolder() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File destFolder = new File(tmpDir, "compositeElementExport");
        int index = 0;
        while (destFolder.exists()) {
            destFolder = new File(tmpDir, "compositeElementExport" + index);
            ++index;
        }
        destFolder.deleteOnExit();
        return destFolder;
    }
}

