/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.MGraphicElement;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class MCompositeElement
extends MGraphicElement {
    private static final long serialVersionUID = -1234707361853922316L;
    private String path;
    private String name;
    private ImageDescriptor iconSmall;
    private ImageDescriptor iconBig;
    private String description;
    private String iconPathSmall;
    private String iconPathBig;
    private String groupID;

    public MCompositeElement(String name, String description, String groupID, String path, String iconPathSmall, String iconPathBig) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)path);
        this.path = path;
        this.name = name;
        this.description = description;
        this.groupID = groupID;
        this.iconPathSmall = iconPathSmall;
        this.iconPathBig = iconPathBig;
        this.iconSmall = JaspersoftStudioPlugin.getInstance().getImageDescriptor("/icons/resources/custom_tool-16.png");
        this.iconBig = JaspersoftStudioPlugin.getInstance().getImageDescriptor("/icons/resources/custom_tool-32.png");
        if (iconPathSmall != null) {
            File elementIcon = new File(iconPathSmall);
            if (elementIcon.exists()) {
                this.iconSmall = ResourceManager.getImageDescriptor((String)elementIcon.getAbsolutePath());
            }
            if ((elementIcon = new File(iconPathBig)).exists()) {
                this.iconBig = ResourceManager.getImageDescriptor((String)elementIcon.getAbsolutePath());
            }
        }
    }

    public ImageDescriptor getIconSmall() {
        return this.iconSmall;
    }

    public ImageDescriptor getIconBig() {
        return this.iconBig;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupId() {
        return this.groupID;
    }

    public String getPath() {
        return this.path;
    }

    public String getIconPathSmall() {
        return this.iconPathSmall;
    }

    public String getIconPathBig() {
        return this.iconPathBig;
    }

    public File getResourceFolder() {
        File contentFile = new File(this.path);
        return new File(contentFile.getParentFile(), FilenameUtils.removeExtension((String)contentFile.getName()));
    }
}

