/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementDefinitionWizardPage;
import com.jaspersoft.studio.utils.ImageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CompositeElementDefinitionWizard
extends Wizard {
    private CompositeElementDefinitionWizardPage page0;
    private List<Object> elementContents;

    public CompositeElementDefinitionWizard(List<Object> elementContents) {
        this.elementContents = elementContents;
    }

    public void addPages() {
        this.page0 = new CompositeElementDefinitionWizardPage();
        this.addPage((IWizardPage)this.page0);
    }

    public boolean performFinish() {
        String name = this.page0.getName();
        String iconPath = this.page0.getIconPath();
        String description = this.page0.getElementDescription();
        String groupID = this.page0.getGroupID();
        if (description == null || description.trim().isEmpty()) {
            description = "";
        }
        FileInputStream stream = null;
        try {
            try {
                File iconFile;
                ImageData resized16 = null;
                ImageData resized32 = null;
                if (iconPath != null && (iconFile = new File(iconPath)).exists()) {
                    stream = new FileInputStream(new File(iconPath));
                    Image loadedImage = new Image(null, (InputStream)new FileInputStream(new File(iconPath)));
                    resized16 = ImageUtils.resizeKeepingRatio(16, loadedImage);
                    resized32 = ImageUtils.resizeKeepingRatio(32, loadedImage);
                    loadedImage.dispose();
                }
                CompositeElementManager.INSTANCE.addCompositeElement(name, description, groupID, resized16, resized32, this.elementContents);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
                UIUtils.showError((Throwable)ex);
                FileUtils.closeStream(stream);
            }
        }
        finally {
            FileUtils.closeStream(stream);
        }
        return true;
    }
}

