/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementDefinitionWizardPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.PaletteGroup;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.Composite;

public class CompositeElementEditWizardPage
extends CompositeElementDefinitionWizardPage {
    private String initialName;
    private String initialDescription;
    private String initialGroupId;
    private String initialImagePath = "";

    public CompositeElementEditWizardPage(String initialName, String initialDescription, String initialGroupId, String initialImagePath) {
        File image;
        this.initialDescription = initialDescription;
        this.initialName = initialName;
        this.initialGroupId = initialGroupId;
        if (initialImagePath != null && (image = new File(initialImagePath)).exists()) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File destFile = new File(tmpDir, image.getName());
            try {
                FileUtils.copyFile((File)image, (File)destFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            destFile.deleteOnExit();
            this.initialImagePath = destFile.getAbsolutePath();
        }
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.nameText.setText(this.initialName);
        this.descriptionText.setText(this.initialDescription);
        this.iconPathText.setText(this.initialImagePath);
        int index = 0;
        for (PaletteGroup group : this.groups) {
            if (group.getId().equals(this.initialGroupId)) break;
            ++index;
        }
        this.palettePosition.select(index);
        this.addAfterInitializationListener();
    }

    protected void addAfterInitializationListener() {
        super.addListeners();
    }

    @Override
    protected void addListeners() {
    }

    @Override
    public boolean isPageComplete() {
        String name = this.getName().trim();
        if (name.isEmpty()) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameEmpry);
        } else if (!net.sf.jasperreports.eclipse.util.FileUtils.isValidFilename((String)name)) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_invalidFileName);
        } else if (!this.initialName.equals(name) && CompositeElementManager.INSTANCE.isNameAlreadyUsed(name.trim())) {
            this.setErrorMessage(Messages.ToolDefinitionWizardPage_errorNameUsed);
        } else {
            this.setErrorMessage(null);
            this.setDescription(Messages.ToolDefinitionWizardPage_description);
        }
        return this.getErrorMessage() == null;
    }
}

