/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.editor.tools.wizards.CompositeElementImportWizardPage;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CompositeElementImportWizard
extends Wizard {
    private List<MCompositeElement> elementsToImport;
    private List<CompositeElementImportWizardPage> pages = new ArrayList<CompositeElementImportWizardPage>();

    public CompositeElementImportWizard(List<MCompositeElement> elementsToImport) {
        this.elementsToImport = elementsToImport;
    }

    public void addPages() {
        int currentElement = 1;
        for (MCompositeElement elementToImport : this.elementsToImport) {
            CompositeElementImportWizardPage currentPage = new CompositeElementImportWizardPage(elementToImport, currentElement, this.elementsToImport.size());
            this.pages.add(currentPage);
            this.addPage((IWizardPage)currentPage);
            ++currentElement;
        }
    }

    public boolean performFinish() {
        for (CompositeElementImportWizardPage page0 : this.pages) {
            FileInputStream stream;
            block12: {
                String name = page0.getName();
                String iconPath = page0.getIconPath();
                String groupID = page0.getGroupID();
                String description = page0.getElementDescription();
                if (description == null || description.trim().isEmpty()) {
                    description = "";
                }
                stream = null;
                try {
                    try {
                        File iconFile;
                        ImageData resized16 = null;
                        ImageData resized32 = null;
                        if (iconPath != null && (iconFile = new File(iconPath)).exists()) {
                            stream = new FileInputStream(new File(iconPath));
                            Image loadedImage = new Image(null, (InputStream)new FileInputStream(new File(iconPath)));
                            resized16 = ImageUtils.resizeKeepingRatio(16, loadedImage);
                            resized32 = ImageUtils.resizeKeepingRatio(32, loadedImage);
                            loadedImage.dispose();
                        }
                        ByteArrayInputStream in = null;
                        JasperDesign result = null;
                        try {
                            try {
                                File componentFile = new File(page0.getElementToImport().getPath());
                                File resourceFolder = page0.getElementToImport().getResourceFolder();
                                in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)componentFile));
                                JasperReportsConfiguration jConfig = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
                                result = new JRXmlLoader((JasperReportsContext)jConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)jConfig)).loadXML((InputStream)in);
                                this.checkResources(result.getTitle().getChildren(), resourceFolder, name);
                                jConfig.setJasperDesign(result);
                                CompositeElementManager.INSTANCE.addCompositeElement(name, description, groupID, resized16, resized32, result, resourceFolder);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                            throw throwable;
                        }
                        net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                        UIUtils.showError((Throwable)ex);
                        net.sf.jasperreports.eclipse.util.FileUtils.closeStream(stream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(stream);
                    throw throwable;
                }
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream(stream);
        }
        return true;
    }

    private void checkResources(List<JRChild> children, File currentResourcesLocation, String elementNewName) {
        for (JRChild newElement : children) {
            String textualExp;
            File oldResource;
            JRExpression exp;
            if (newElement instanceof JRDesignImage && (exp = ((JRDesignImage)newElement).getExpression()) != null && new File(currentResourcesLocation, (oldResource = new File(textualExp = JRExpressionUtil.getSimpleExpressionText((JRExpression)exp))).getName()).exists()) {
                File newResourceFolder = CompositeElementManager.INSTANCE.getResourceDir(elementNewName);
                File newResource = new File(newResourceFolder, oldResource.getName());
                ((JRDesignImage)newElement).setExpression((JRExpression)new JRDesignExpression("\"" + newResource.getAbsolutePath() + "\""));
            }
            if (!(newElement instanceof JRElementGroup)) continue;
            this.checkResources(((JRElementGroup)newElement).getChildren(), currentResourcesLocation, elementNewName);
        }
    }
}

