/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools.wizards;

import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.HashMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CompositeElementsExportWizardPage
extends JSSWizardPage {
    private HashMap<MCompositeElement, Boolean> selectionMap = new HashMap();
    private MCompositeElement alreadySelectedElement;
    private SelectionAdapter checkSelected = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MCompositeElement def = (MCompositeElement)e.widget.getData();
            Button btn = (Button)e.widget;
            CompositeElementsExportWizardPage.this.selectionMap.put(def, btn.getSelection());
            CompositeElementsExportWizardPage.this.getContainer().updateButtons();
        }
    };

    protected CompositeElementsExportWizardPage(MCompositeElement alreadySelectedElement) {
        super("showCompositeElementsPage");
        this.setTitle(Messages.CompositeElementsExportWizardPage_pageTitle);
        this.setMessage(Messages.CompositeElementsExportWizardPage_pageDescription);
        this.alreadySelectedElement = alreadySelectedElement;
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 512);
        Composite child = new Composite((Composite)sc, 0);
        child.setLayout((Layout)new GridLayout(1, false));
        for (MCompositeElement definition : CompositeElementManager.INSTANCE.getAvailableElements()) {
            Button selectionButton = new Button(child, 32);
            selectionButton.setLayoutData((Object)new GridData(768));
            selectionButton.setText(definition.getName());
            selectionButton.setData((Object)definition);
            Boolean alreadyChecked = definition == this.alreadySelectedElement;
            selectionButton.setSelection(alreadyChecked.booleanValue());
            selectionButton.addSelectionListener((SelectionListener)this.checkSelected);
            this.selectionMap.put(definition, alreadyChecked);
        }
        sc.setContent((Control)child);
        sc.setMinSize(400, child.computeSize((int)400, (int)-1).y);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
    }

    protected HashMap<MCompositeElement, Boolean> getSelection() {
        return this.selectionMap;
    }

    @Override
    protected String getContextName() {
        return null;
    }

    public boolean isPageComplete() {
        for (Boolean value : this.selectionMap.values()) {
            if (!value.booleanValue()) continue;
            this.setErrorMessage(null);
            this.setDescription(Messages.CompositeElementsExportWizardPage_pageDescription);
            return true;
        }
        this.setErrorMessage(Messages.CompositeElementsExportWizardPage_selectOneElementError);
        return false;
    }
}

