/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml.format;

import com.jaspersoft.studio.editor.xml.format.DefaultFormattingStrategy;

public class XMLFormattingStrategy
extends DefaultFormattingStrategy {
    private String initialIndentation;
    boolean lastTagWasOpening;

    @Override
    public void formatterStarts(String initialIndentation) {
        this.initialIndentation = initialIndentation;
    }

    @Override
    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        if (isLineStart) {
            indentation = this.initialIndentation;
        }
        if ((content = this.formatContent(content)).indexOf("<") == -1) {
            this.lastTagWasOpening = content.indexOf("/>") == -1;
            return content;
        }
        if (content.indexOf("/>") != -1) {
            if (this.lastTagWasOpening) {
                indentation = String.valueOf(indentation) + "\t";
            }
            this.lastTagWasOpening = false;
            return String.valueOf(lineSeparator) + indentation + content;
        }
        if (content.indexOf("</") != -1) {
            boolean lastOpening = this.lastTagWasOpening;
            this.lastTagWasOpening = false;
            if (!lastOpening) {
                if (indentation.length() > 1) {
                    indentation = indentation.substring(0, indentation.length() - 1);
                }
                return String.valueOf(lineSeparator) + indentation + content;
            }
            return content;
        }
        if (content.indexOf("<") != -1) {
            if (this.lastTagWasOpening) {
                indentation = String.valueOf(indentation) + "\t";
            }
            this.lastTagWasOpening = true;
            return String.valueOf(lineSeparator) + indentation + content;
        }
        return content;
    }

    protected String formatContent(String content) {
        String[] contentParts = content.split("\\s+|\r|\n");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < contentParts.length) {
            buffer.append(contentParts[i].trim()).append(" ");
            ++i;
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        return buffer.toString();
    }

    @Override
    public void formatterStops() {
    }
}

