/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.xml.outline;

import com.jaspersoft.studio.editor.xml.outline.OutlineContentHandler;
import com.jaspersoft.studio.editor.xml.outline.OutlineContentProvider;
import com.jaspersoft.studio.editor.xml.outline.OutlineLabelProvider;
import com.jaspersoft.studio.editor.xml.xml.XMLElement;
import com.jaspersoft.studio.editor.xml.xml.XMLParser;
import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.xml.sax.helpers.LocatorImpl;

public class EditorContentOutlinePage
extends ContentOutlinePage {
    private static XMLElement loadingNode = new XMLElement("root");
    private static XMLElement noInput;
    private ITextEditor editor;
    private Object input;
    private OutlineContentProvider outlineContentProvider;
    private OutlineLabelProvider outlineLabelProvider;
    protected static final String TAG_POSITIONS = "__tag_positions";
    protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("__tag_positions");
    private XMLLoaderJob xmlLoaderJob = null;
    private XMLElement root = null;

    static {
        loadingNode.addChildElement(new XMLElement("Loading the outline..."));
        noInput = new XMLElement("root");
        noInput.addChildElement(new XMLElement("No valid input"));
    }

    public EditorContentOutlinePage(ITextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.outlineContentProvider = new OutlineContentProvider();
        viewer.setContentProvider((IContentProvider)this.outlineContentProvider);
        this.outlineLabelProvider = new OutlineLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.outlineLabelProvider);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setRootIntoTree();
    }

    public void setInput(Object input) {
        if (!ModelUtils.safeEquals(input, this.input)) {
            this.input = input;
            this.update();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            XMLElement element = (XMLElement)((IStructuredSelection)selection).getFirstElement();
            if (element.getPosition() != null) {
                int start = element.getPosition().getOffset();
                int length = element.getPosition().getLength();
                try {
                    this.editor.setHighlightRange(start, length, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.editor.resetHighlightRange();
                }
            }
        }
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            viewer.setInput((Object)loadingNode);
            if (this.xmlLoaderJob != null) {
                this.xmlLoaderJob.cancel();
                this.xmlLoaderJob = null;
            }
            this.xmlLoaderJob = new XMLLoaderJob();
            new Thread(this.xmlLoaderJob).start();
        }
    }

    private synchronized void setRootIntoTree() {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Control control;
                TreeViewer viewer = EditorContentOutlinePage.this.getTreeViewer();
                if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    if (EditorContentOutlinePage.this.root == null) {
                        viewer.setInput((Object)noInput);
                    } else {
                        viewer.setInput((Object)EditorContentOutlinePage.this.root);
                    }
                    control.setRedraw(true);
                }
            }
        });
    }

    private final class XMLLoaderJob
    implements Runnable {
        private IProgressMonitor monitor = new NullProgressMonitor();

        @Override
        public void run() {
            IDocument document = this.getDocument(EditorContentOutlinePage.this.input);
            XMLElement newRoot = null;
            if (document != null && !this.monitor.isCanceled()) {
                document.addPositionCategory(EditorContentOutlinePage.TAG_POSITIONS);
                document.addPositionUpdater(EditorContentOutlinePage.this.positionUpdater);
                newRoot = this.parseRootElement(document, this.monitor);
            }
            if (!this.monitor.isCanceled()) {
                EditorContentOutlinePage.this.root = newRoot;
                EditorContentOutlinePage.this.setRootIntoTree();
            }
        }

        public void cancel() {
            this.monitor.setCanceled(true);
        }

        private XMLElement parseRootElement(IDocument document, IProgressMonitor monitor) {
            try {
                XMLParser xmlParser = new XMLParser();
                OutlineContentHandler contentHandler = new OutlineContentHandler(monitor);
                contentHandler.setDocument(document);
                contentHandler.setPositionCategory(EditorContentOutlinePage.TAG_POSITIONS);
                contentHandler.setDocumentLocator(new LocatorImpl());
                xmlParser.setContentHandler(contentHandler);
                xmlParser.doParse(document.get());
                XMLElement root = contentHandler.getRootElement();
                return root;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private IDocument getDocument(Object input) {
            if (input == null) {
                return null;
            }
            if (input instanceof String) {
                return new Document((String)input);
            }
            return this.getDocument(EditorContentOutlinePage.this.editor.getDocumentProvider().getDocument(input).get());
        }
    }
}

