/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.font;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.ABasicEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.FontPathWizard;
import com.jaspersoft.studio.preferences.fonts.FontSetDialog;
import com.jaspersoft.studio.preferences.fonts.FontSetFamilyDialog;
import com.jaspersoft.studio.preferences.fonts.FontURLWizard;
import com.jaspersoft.studio.preferences.fonts.SelectFontSetSetDialog;
import com.jaspersoft.studio.preferences.fonts.wizard.FontConfigWizard;
import com.jaspersoft.studio.utils.ModelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsContainer;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.FontSetFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionsContainer;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontSetFamily;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class FontEditor
extends ABasicEditor {
    public static final String ID = "com.jaspersoft.studio.fontextension.editor";
    public static final String DEFAULT_FILENAME = "fonts.xml";
    private static String lastLocation;
    private FontExtensionsCollector container;
    private boolean saving = false;
    private TreeViewer tree;
    private Button addURLButton;
    private Button addPathButton;
    private Button addButton;
    private Button duplicateButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button addSetButton;
    private Button addToSetButton;
    private Button exportButton;
    private SelectionListener selectionListener;

    public FontEditor() {
        super(true);
    }

    @Override
    protected void setInput(IEditorInput input) {
        block8: {
            if (this.saving) {
                return;
            }
            super.setInput(input);
            InputStream in = null;
            try {
                try {
                    IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                    in = file.getContents(true);
                    this.container = new FontExtensionsCollector();
                    SimpleFontExtensionHelper.getInstance().loadFontExtensions((JasperReportsContext)this.getJrContext(), in, (FontExtensionsReceiver)this.container, false);
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream(in);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(in);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)in);
        }
        if (this.container == null) {
            this.container = new FontExtensionsCollector();
        }
        if (this.tree != null) {
            this.tree.setInput((Object)this.container);
            this.tree.refresh(true);
        }
    }

    public void createPartControl(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.tree = new TreeViewer(cmp, 2818);
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof FontExtensionsCollector) {
                    ArrayList lst = new ArrayList();
                    lst.addAll(((FontExtensionsCollector)inputElement).getFontFamilies());
                    lst.addAll(((FontExtensionsCollector)inputElement).getFontSets());
                    return lst.toArray();
                }
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SimpleFontSet) {
                    return ((SimpleFontSet)parentElement).getFamilies().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof SimpleFontSet && !Misc.isNullOrEmpty((Collection)((SimpleFontSet)element).getFamilies());
            }
        });
        this.tree.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FontLabelProvider()));
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.tree.setInput((Object)this.container);
        this.tree.addDoubleClickListener(event -> {
            if (this.editButton.isEnabled()) {
                this.editPressed();
            }
        });
        this.tree.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontEditor.this.selectionChanged();
            }
        });
        this.createButtons(cmp);
    }

    private void createButtons(Composite cmp) {
        Composite c = new Composite(cmp, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(2));
        this.addURLButton = this.createPushButton(c, Messages.JRVersionPage_3);
        this.addPathButton = this.createPushButton(c, Messages.JRVersionPage_4);
        this.addButton = this.createPushButton(c, Messages.common_add);
        ((GridData)this.addButton.getLayoutData()).verticalIndent = 20;
        this.duplicateButton = this.createPushButton(c, Messages.common_duplicate);
        this.editButton = this.createPushButton(c, Messages.FontListFieldEditor_editButton);
        this.removeButton = this.createPushButton(c, Messages.common_delete);
        this.upButton = this.createPushButton(c, Messages.common_up);
        this.downButton = this.createPushButton(c, Messages.common_down);
        this.addSetButton = this.createPushButton(c, Messages.FontListFieldEditor_6);
        ((GridData)this.addSetButton.getLayoutData()).verticalIndent = 20;
        this.addToSetButton = this.createPushButton(c, "Add To Set");
        this.exportButton = this.createPushButton(c, Messages.FontListFieldEditor_exportButton);
        ((GridData)this.exportButton.getLayoutData()).verticalIndent = 20;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.editButton.setEnabled(enabled);
        this.addPathButton.setEnabled(enabled);
        this.addURLButton.setEnabled(enabled);
        this.addSetButton.setEnabled(enabled);
        this.addToSetButton.setEnabled(enabled);
    }

    private Button createPushButton(Composite box, String title) {
        Button b = new Button(box, 8);
        b.setText(title);
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener(this.getSelectionListener());
        return b;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == FontEditor.this.addButton) {
                        FontEditor.this.addPressed();
                    } else if (widget == FontEditor.this.addSetButton) {
                        FontEditor.this.addSetPressed();
                    } else if (widget == FontEditor.this.addToSetButton) {
                        FontEditor.this.add2SetPressed();
                    } else if (widget == FontEditor.this.duplicateButton) {
                        FontEditor.this.duplicatePressed();
                    } else if (widget == FontEditor.this.removeButton) {
                        FontEditor.this.removePressed();
                    } else if (widget == FontEditor.this.upButton) {
                        FontEditor.this.upPressed();
                    } else if (widget == FontEditor.this.downButton) {
                        FontEditor.this.downPressed();
                    } else if (widget == FontEditor.this.editButton) {
                        FontEditor.this.editPressed();
                    } else if (widget == FontEditor.this.exportButton) {
                        FontEditor.this.exportPressed();
                    } else if (widget == FontEditor.this.tree.getTree()) {
                        FontEditor.this.selectionChanged();
                    } else if (widget == FontEditor.this.addURLButton) {
                        FontEditor.this.addURLPressed();
                    } else if (widget == FontEditor.this.addPathButton) {
                        FontEditor.this.addPathPressed();
                    }
                }
            };
        }
        return this.selectionListener;
    }

    protected void selectionChanged() {
        boolean en;
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (this.addButton != null) {
            this.addButton.setEnabled(sel.isEmpty() || !sel.isEmpty() && sel.size() == 1 && !(sel.getFirstElement() instanceof SimpleFontSetFamily));
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(!sel.isEmpty() && sel.size() == 1);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(!sel.isEmpty() && !(sel.getFirstElement() instanceof SimpleFontSetFamily));
        }
        if (this.exportButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (!(obj instanceof FontSetFamily)) continue;
                    en = false;
                    break;
                }
            }
            this.exportButton.setEnabled(en);
        }
        if (this.addSetButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (obj instanceof FontFamily) continue;
                    en = false;
                    break;
                }
            }
            this.addSetButton.setEnabled(en);
        }
        if (this.addToSetButton != null) {
            boolean bl = en = !sel.isEmpty();
            if (en) {
                for (Object obj : sel.toList()) {
                    if (obj instanceof FontFamily) continue;
                    en = false;
                    break;
                }
            }
            this.addToSetButton.setEnabled(en);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(!sel.isEmpty());
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(!sel.isEmpty() && this.isRemovable(sel));
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(!sel.isEmpty() && this.isSortable(sel) && this.canGoUp(sel));
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(!sel.isEmpty() && this.isSortable(sel) && this.canGoDown(sel));
        }
    }

    protected boolean canGoUp(StructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            return this.container.getFontFamilies().indexOf(obj) > 0;
        }
        if (obj instanceof FontSet) {
            return this.container.getFontSets().indexOf(obj) > 0;
        }
        if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.container.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                return fs.getFamilies().indexOf(obj) > 0;
            }
        }
        return false;
    }

    protected boolean canGoDown(StructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            return this.container.getFontFamilies().indexOf(obj) < this.container.getFontFamilies().size() - 1;
        }
        if (obj instanceof FontSet) {
            return this.container.getFontSets().indexOf(obj) < this.container.getFontSets().size() - 1;
        }
        if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.container.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                return fs.getFamilies().indexOf(obj) < fs.getFamilies().size() - 1;
            }
        }
        return false;
    }

    protected boolean isSortable(StructuredSelection sel) {
        return sel.size() == 1;
    }

    protected boolean isRemovable(StructuredSelection sel) {
        return true;
    }

    public void setFocus() {
        this.tree.getTree().setFocus();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        block5: {
            try {
                try {
                    IFile resource = ((IFileEditorInput)this.getEditorInput()).getFile();
                    IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                    this.saving = true;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SimpleFontExtensionHelper.writeFontExtensionsXml((OutputStream)os, (FontExtensionsContainer)new SimpleFontExtensionsContainer(this.container.getFontFamilies(), this.container.getFontSets()));
                    file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), true, true, monitor);
                    Markers.deleteMarkers((IResource)resource);
                }
                catch (JRException | CoreException e) {
                    UIUtils.showError((Throwable)e);
                    this.saving = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.saving = false;
                throw throwable;
            }
            this.saving = false;
        }
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    @Override
    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(((FileEditorInput)this.getEditorInput()).getFile());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)modelFile);
            this.setInput((IEditorInput)modelFile);
            this.setPartName(file.getName());
            IProgressMonitor progressMonitor = this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            this.doSave(progressMonitor);
        }
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void upPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            int ind = this.container.getFontFamilies().indexOf(obj);
            this.container.getFontFamilies().remove(ind);
            this.container.getFontFamilies().add(ind - 1, (FontFamily)obj);
        } else if (obj instanceof FontSet) {
            int ind = this.container.getFontSets().indexOf(obj);
            this.container.getFontSets().remove(ind);
            this.container.getFontSets().add(ind - 1, (FontSet)obj);
        } else if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.container.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                int ind = fs.getFamilies().indexOf(obj);
                fs.getFamilies().remove(ind);
                fs.getFamilies().add(ind - 1, (FontSetFamily)obj);
                break;
            }
        }
        this.handleValueChanged();
        this.tree.refresh(true);
        this.tree.setSelection((ISelection)new StructuredSelection(obj), true);
        this.selectionChanged();
    }

    protected void downPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FontFamily) {
            int ind = this.container.getFontFamilies().indexOf(obj);
            this.container.getFontFamilies().remove(ind);
            this.container.getFontFamilies().add(ind + 1, (FontFamily)obj);
        } else if (obj instanceof FontSet) {
            int ind = this.container.getFontSets().indexOf(obj);
            this.container.getFontSets().remove(ind);
            this.container.getFontSets().add(ind + 1, (FontSet)obj);
        } else if (obj instanceof FontSetFamily) {
            for (FontSet fs : this.container.getFontSets()) {
                if (!fs.getFamilies().contains(obj)) continue;
                int ind = fs.getFamilies().indexOf(obj);
                fs.getFamilies().remove(ind);
                fs.getFamilies().add(ind + 1, (FontSetFamily)obj);
                break;
            }
        }
        this.handleValueChanged();
        this.tree.refresh(true);
        this.tree.setSelection((ISelection)new StructuredSelection(obj), true);
        this.selectionChanged();
    }

    protected void addPressed() {
        SimpleFontFamily ff = new SimpleFontFamily();
        ff.setName(Messages.FontListFieldEditor_newFontSuggestedName);
        FontFamily font = FontEditor.runDialog((FontFamily)ff);
        if (font != null) {
            this.container.getFontFamilies().add(ff);
            this.handleValueChanged();
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)ff), true);
            this.selectionChanged();
        }
    }

    protected void removePressed() {
        if (UIUtils.showDeleteConfirmation()) {
            StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
            for (Object obj : sel.toList()) {
                if (obj instanceof FontFamily) {
                    this.container.getFontFamilies().remove(obj);
                    continue;
                }
                if (obj instanceof FontSet) {
                    this.container.getFontSets().remove(obj);
                    continue;
                }
                if (!(obj instanceof FontSetFamily)) continue;
                for (FontSet fs : this.container.getFontSets()) {
                    fs.getFamilies().remove(obj);
                }
            }
            this.handleValueChanged();
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    protected void duplicatePressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        for (Object obj : sel.toList()) {
            boolean exists;
            int i;
            String newname;
            SimpleFontFamily clone;
            if (obj instanceof FontFamily) {
                clone = (SimpleFontFamily)((SimpleFontFamily)obj).clone();
                newname = String.valueOf(((FontFamily)obj).getName()) + "_copy";
                i = 1;
                while (i < 1000) {
                    exists = false;
                    for (FontFamily f : this.container.getFontFamilies()) {
                        if (!f.getName().equals(newname)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) break;
                    newname = String.valueOf(((FontFamily)obj).getName()) + "_copy" + i;
                    ++i;
                }
                clone.setName(newname);
                this.container.getFontFamilies().add(clone);
                this.handleValueChanged();
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)clone), true);
                this.selectionChanged();
                continue;
            }
            if (!(obj instanceof FontSet)) continue;
            clone = (SimpleFontSet)((SimpleFontSet)obj).clone();
            newname = String.valueOf(((FontSet)obj).getName()) + "_copy";
            i = 1;
            while (i < 1000) {
                exists = false;
                for (FontFamily f : this.container.getFontSets()) {
                    if (!f.getName().equals(newname)) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                newname = String.valueOf(((FontSet)obj).getName()) + "_copy" + i;
                ++i;
            }
            clone.setName(newname);
            this.container.getFontSets().add(clone);
            this.handleValueChanged();
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)clone), true);
            this.selectionChanged();
        }
    }

    protected void editPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (sel.getFirstElement() instanceof SimpleFontFamily) {
            SimpleFontFamily font = (SimpleFontFamily)sel.getFirstElement();
            int index = this.container.getFontFamilies().indexOf(font);
            if ((font = FontEditor.runDialog((FontFamily)font.clone())) != null) {
                this.container.getFontFamilies().set(index, font);
                this.handleValueChanged();
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)font), true);
                this.selectionChanged();
            }
        } else if (sel.getFirstElement() instanceof SimpleFontSet) {
            SimpleFontSet fset = (SimpleFontSet)sel.getFirstElement();
            FontSetDialog d = new FontSetDialog(UIUtils.getShell(), (SimpleFontSet)fset.clone());
            if (d.open() == 0) {
                fset.setName(d.getValue().getName());
                this.handleValueChanged();
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)fset), true);
                this.selectionChanged();
            }
        } else if (sel.getFirstElement() instanceof SimpleFontSetFamily) {
            SimpleFontSetFamily fsetf = (SimpleFontSetFamily)sel.getFirstElement();
            for (FontSet fs : this.container.getFontSets()) {
                FontSetFamilyDialog d;
                if (!fs.getFamilies().contains(fsetf) || (d = new FontSetFamilyDialog(UIUtils.getShell(), (SimpleFontSet)fs, (SimpleFontSetFamily)fsetf.clone())).open() != 0) continue;
                SimpleFontSetFamily v = d.getValue();
                fsetf.setPrimary(v.isPrimary());
                fsetf.setIncludedScripts(v.getIncludedScripts());
                fsetf.setExcludedScripts(v.getExcludedScripts());
                this.handleValueChanged();
                this.tree.refresh(true);
                this.tree.setSelection((ISelection)new StructuredSelection((Object)fsetf), true);
                this.selectionChanged();
            }
        }
    }

    protected void addSetPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        SimpleFontSet fs = new SimpleFontSet();
        fs.setName("FontSet");
        FontSetDialog d = new FontSetDialog(UIUtils.getShell(), fs);
        if (d.open() == 0) {
            boolean first = true;
            for (Object obj : sel.toList()) {
                if (!(obj instanceof FontFamily)) continue;
                SimpleFontSetFamily fsf = new SimpleFontSetFamily();
                fsf.setFamilyName(((FontFamily)obj).getName());
                fsf.setPrimary(first);
                first = false;
                fs.addFamily((FontSetFamily)fsf);
            }
            this.handleValueChanged();
            this.container.getFontSets().add(fs);
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)fs), true);
            this.selectionChanged();
        }
    }

    protected void add2SetPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        SelectFontSetSetDialog d = new SelectFontSetSetDialog(UIUtils.getShell(), this.container.getFontSets());
        if (d.open() == 0) {
            FontSet fs = d.getValue();
            if (fs == null) {
                return;
            }
            for (Object obj : sel.toList()) {
                if (!(obj instanceof FontFamily)) continue;
                SimpleFontSetFamily fsf = new SimpleFontSetFamily();
                fsf.setFamilyName(((FontFamily)obj).getName());
                ((SimpleFontSet)d.getValue()).addFamily((FontSetFamily)fsf);
            }
            this.handleValueChanged();
            this.tree.refresh(true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)fs), true);
            this.selectionChanged();
        }
    }

    protected void addURLPressed() {
        FontURLWizard wiz = new FontURLWizard(new ArrayList<FontFamily>(this.container.getFontFamilies()));
        WizardDialog d = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wiz);
        d.setPageSize(800, 50);
        if (d.open() == 0) {
            if (this.container == null) {
                this.container = new FontExtensionsCollector();
                this.tree.setInput((Object)this.container);
            }
            this.container.getFontFamilies().clear();
            this.container.getFontFamilies().addAll(wiz.getFonts());
            this.handleValueChanged();
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    protected void addPathPressed() {
        FontPathWizard wiz = new FontPathWizard(new ArrayList<FontFamily>(this.container.getFontFamilies()));
        WizardDialog d = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wiz);
        d.setPageSize(800, 50);
        if (d.open() == 0) {
            if (this.container == null) {
                this.container = new FontExtensionsCollector();
                this.tree.setInput((Object)this.container);
            }
            this.container.getFontFamilies().clear();
            this.container.getFontFamilies().addAll(wiz.getFonts());
            this.handleValueChanged();
            this.tree.refresh(true);
            this.selectionChanged();
        }
    }

    protected void exportPressed() {
        StructuredSelection sel = (StructuredSelection)this.tree.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ArrayList<FontFamily> ff = new ArrayList<FontFamily>();
        for (Object obj : sel.toList()) {
            if (!(obj instanceof FontFamily)) continue;
            ff.add((FontFamily)((JRCloneable)obj).clone());
        }
        ArrayList<FontSet> fs = new ArrayList<FontSet>();
        for (Object obj : sel.toList()) {
            if (!(obj instanceof FontSet)) continue;
            fs.add((FontSet)((JRCloneable)obj).clone());
            block2: for (FontSetFamily fsf : ((FontSet)obj).getFamilies()) {
                for (FontFamily f : this.container.getFontFamilies()) {
                    if (!f.getName().equals(fsf.getFamilyName())) continue;
                    boolean exists = false;
                    for (FontFamily item : ff) {
                        if (!item.getName().equals(fsf.getFamilyName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue block2;
                    ff.add((FontFamily)((JRCloneable)f).clone());
                    continue block2;
                }
            }
        }
        final SimpleFontExtensionsContainer c = new SimpleFontExtensionsContainer(ff, fs);
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fd.setText(Messages.FontListFieldEditor_exportToJar);
        FontEditor.setupLastLocation(fd);
        fd.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        final String selected = fd.open();
        FontEditor.setLastLocation(fd, selected);
        if (selected != null) {
            Job job = new Job(Messages.FontListFieldEditor_exportToJar){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.FontListFieldEditor_exportToJar, -1);
                    try {
                        try {
                            FontEditor.exportJAR(c, selected);
                            IFile[] resource = root.findFilesForLocationURI(new File(selected).toURI());
                            if (resource != null) {
                                IFile[] iFileArray = resource;
                                int n = resource.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFile f = iFileArray[n2];
                                    f.refreshLocal(1, monitor);
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            UIUtils.getDisplay().asyncExec(() -> {
                                OperationStatus status = new OperationStatus(4, JaspersoftStudioPlugin.getUniqueIdentifier(), 1, "Error saving file.", e.getCause());
                                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.FontListFieldEditor_errorSave, null, (IStatus)status);
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
    }

    public static void exportJAR(SimpleFontExtensionsContainer c, String selected) throws IOException, JRException {
        FileOutputStream fos = new FileOutputStream(selected);
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ZipOutputStream zipos = new ZipOutputStream(fos);){
                zipos.setMethod(8);
                String prefix = "family" + new Date().getTime();
                String fontXmlFile = "fonts" + prefix + ".xml";
                ZipEntry propsEntry = new ZipEntry("jasperreports_extension.properties");
                zipos.putNextEntry(propsEntry);
                PrintWriter pw = new PrintWriter(zipos);
                pw.println("net.sf.jasperreports.extension.registry.factory.fonts=net.sf.jasperreports.engine.fonts.SimpleFontExtensionsRegistryFactory");
                pw.println("net.sf.jasperreports.extension.simple.font.families.ireport" + prefix + "=fonts/" + fontXmlFile);
                pw.flush();
                HashSet<String> names = new HashSet<String>();
                for (FontFamily f : c.getFontFamilies()) {
                    FontEditor.writeFont2zip(names, zipos, f, (SimpleFontFace)f.getNormalFace());
                    FontEditor.writeFont2zip(names, zipos, f, (SimpleFontFace)f.getBoldFace());
                    FontEditor.writeFont2zip(names, zipos, f, (SimpleFontFace)f.getItalicFace());
                    FontEditor.writeFont2zip(names, zipos, f, (SimpleFontFace)f.getBoldItalicFace());
                    String pdfenc = f.getPdfEncoding();
                    if (ModelUtils.getKey4PDFEncoding(pdfenc) != null) continue;
                    pdfenc = ModelUtils.getPDFEncoding2key(pdfenc);
                    ((SimpleFontFamily)f).setPdfEncoding(pdfenc);
                }
                ZipEntry fontsXmlEntry = new ZipEntry("fonts/" + fontXmlFile);
                zipos.putNextEntry(fontsXmlEntry);
                SimpleFontExtensionHelper.writeFontExtensionsXml((OutputStream)zipos, (FontExtensionsContainer)c);
                zipos.finish();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            FileUtils.closeStream((Closeable)fos);
        }
    }

    public static void writeFont2zip(Set<String> names, ZipOutputStream zipos, FontFamily fontFamily, SimpleFontFace font) throws IOException {
        if (font == null) {
            return;
        }
        try {
            font.setTtf(FontEditor.writeFont(names, zipos, fontFamily, (FontFace)font, font.getTtf()), false);
        }
        catch (Exception exception) {}
        font.setPdf(FontEditor.writeFont(names, zipos, fontFamily, (FontFace)font, font.getPdf()));
        font.setEot(FontEditor.writeFont(names, zipos, fontFamily, (FontFace)font, font.getEot()));
        font.setSvg(FontEditor.writeFont(names, zipos, fontFamily, (FontFace)font, font.getSvg()));
        font.setWoff(FontEditor.writeFont(names, zipos, fontFamily, (FontFace)font, font.getWoff()));
    }

    public static String writeFont(Set<String> names, ZipOutputStream zipos, FontFamily fontFamily, FontFace font, String fontname) throws IOException {
        if (Misc.isNullOrEmpty((String)fontname)) {
            return fontname;
        }
        File file = new File(fontname);
        if (file.exists()) {
            String name = "fonts/" + StringUtils.toPackageName((String)fontFamily.getName()) + "/" + file.getName();
            if (!names.contains(name)) {
                ZipEntry ttfZipEntry = new ZipEntry(name);
                zipos.putNextEntry(ttfZipEntry);
                FileInputStream in = new FileInputStream(fontname);
                try {
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        zipos.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    FileUtils.closeStream((Closeable)in);
                }
                names.add(name);
            }
            fontname = name;
        }
        return fontname;
    }

    public static FontFamily runDialog(FontFamily font) {
        FontConfigWizard wizard = new FontConfigWizard();
        WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
        wizard.setFont(font);
        dialog.create();
        if (dialog.open() == 0) {
            return wizard.getFont();
        }
        return null;
    }

    public static String setupLastLocation(FileDialog dialog) {
        if (lastLocation == null) {
            lastLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        dialog.setFilterPath(lastLocation);
        return lastLocation;
    }

    public static void setLastLocation(FileDialog dialog, String selected) {
        if (!Misc.isNullOrEmpty((String)selected)) {
            lastLocation = selected.substring(0, selected.lastIndexOf(File.separatorChar));
        } else if (!Misc.isNullOrEmpty((String)dialog.getFileName())) {
            lastLocation = dialog.getFileName();
        }
    }

    class FontLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        FontLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SimpleFontSet) {
                return ((SimpleFontSet)element).getName();
            }
            if (element instanceof SimpleFontFamily) {
                return ((SimpleFontFamily)element).getName();
            }
            if (element instanceof SimpleFontSetFamily) {
                return ((SimpleFontSetFamily)element).getFamilyName();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof SimpleFontSetFamily && ((SimpleFontSetFamily)element).isPrimary()) {
                return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/check-16.png");
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            StyledString ss = new StyledString();
            if (element instanceof SimpleFontSet) {
                ss.append(((SimpleFontSet)element).getName(), StyledString.QUALIFIER_STYLER);
            } else if (element instanceof SimpleFontFamily) {
                ss.append(((SimpleFontFamily)element).getName());
            } else if (element instanceof SimpleFontSetFamily) {
                ss.append(((SimpleFontSetFamily)element).getFamilyName(), StyledString.DECORATIONS_STYLER);
            }
            return ss;
        }
    }
}

