/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.font;

import com.jaspersoft.studio.font.FontExtensionNewWizardPage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fonts.FontExtensionsContainer;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionsContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class FontExtensionNewWizard
extends Wizard
implements INewWizard {
    private FontExtensionNewWizardPage page;
    private ISelection selection;

    public FontExtensionNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new FontExtensionNewWizardPage("filepage", (IStructuredSelection)this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final IPath path = this.page.getContainerFullPath();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        FontExtensionNewWizard.this.doFinish(path, "fonts.xml", monitor);
                    }
                    catch (JRException | CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        return true;
    }

    private void doFinish(IPath path, String fname, IProgressMonitor monitor) throws CoreException, JRException {
        monitor.beginTask("Creating fonts extension file: " + fname, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder f = root.getFolder(path);
        if (!f.exists()) {
            FileUtils.createFolder((IContainer)f, (IProgressMonitor)monitor);
        }
        IFile file = f.getFile((IPath)new Path(fname));
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream stream = this.openContentStream();){
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                IDE.setDefaultEditor((IFile)file, (String)"com.jaspersoft.studio.fontextension.editor");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening the editor");
        this.getShell().getDisplay().asyncExec(() -> {
            try {
                IWorkbenchPage p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (p != null) {
                    IDE.openEditor((IWorkbenchPage)p, (IFile)file, (String)"com.jaspersoft.studio.fontextension.editor", (boolean)true);
                }
            }
            catch (PartInitException e) {
                UIUtils.showError((Throwable)e);
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws JRException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SimpleFontExtensionHelper.writeFontExtensionsXml((OutputStream)os, (FontExtensionsContainer)new SimpleFontExtensionsContainer(new ArrayList(), new ArrayList()));
        return new ByteArrayInputStream(os.toByteArray());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

