/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class IncreaseHSpaceAction
extends AbstractFormattingAction {
    public static final String ID = "increasehspace";

    public IncreaseHSpaceAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.IncreaseHSpaceAction_actionName);
        this.setToolTipText(Messages.IncreaseHSpaceAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/elem_add_hspace_plus.png"));
    }

    public static JSSCompoundCommand generateCommand(List<APropertyNode> nodes) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        if (nodes.isEmpty()) {
            return command;
        }
        List<APropertyNode> sortedElements = IncreaseHSpaceAction.sortXY(nodes);
        int i = 1;
        while (i < sortedElements.size()) {
            APropertyNode actualNode = sortedElements.get(i);
            command.setReferenceNodeIfNull(actualNode);
            JRDesignElement element = (JRDesignElement)actualNode.getValue();
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(actualNode);
            setCommand.setPropertyId("x");
            setCommand.setPropertyValue(element.getX() + 5 * i);
            command.add(setCommand);
            ++i;
        }
        return command;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = null;
        if (!nodes.isEmpty()) {
            command = IncreaseHSpaceAction.generateCommand(nodes);
            command.setDebugLabel(this.getText());
        }
        return command;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 1;
    }
}

