/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.formatting.actions.AlignMarginTopAction;
import com.jaspersoft.studio.formatting.actions.SameHeightMinAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class OrganizeAsTableAction
extends AbstractFormattingAction {
    public static final String ID = "organizeastable";

    public OrganizeAsTableAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.OrganizeAsTableAction_actionName);
        this.setToolTipText(Messages.OrganizeAsTableAction_actionDescription);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/organize_as_table.png"));
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 0;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel(this.getText());
        if (nodes.isEmpty()) {
            return command;
        }
        nodes = OrganizeAsTableAction.sortXY(nodes);
        int currentX = 0;
        command.add((Command)AlignMarginTopAction.generateCommand(nodes));
        for (APropertyNode element : nodes) {
            command.setReferenceNodeIfNull(element);
            Rectangle oldBounds = OrganizeAsTableAction.getElementBounds((JRDesignElement)element.getValue());
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(element);
            setCommand.setPropertyId("x");
            setCommand.setPropertyValue(currentX);
            command.add(setCommand);
            currentX += oldBounds.width + 5;
        }
        command.add((Command)SameHeightMinAction.generateCommand(nodes));
        return command;
    }
}

