/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.help;

import com.jaspersoft.studio.help.ovverriders.GenericOverrider;
import com.jaspersoft.studio.help.ovverriders.IHelpOverrider;
import com.jaspersoft.studio.help.ovverriders.RegularExpressionOverrider;
import com.jaspersoft.studio.help.ovverriders.StylesOverrider;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class TableHelpListener
implements Listener {
    private static List<IHelpOverrider> overrideMap = null;
    private Table table;

    protected TableHelpListener(Table table) {
        this.table = table;
    }

    protected IHelpOverrider getOverrider(String propertyName) {
        for (IHelpOverrider actualElement : overrideMap) {
            if (!actualElement.isOverrided(propertyName)) continue;
            return actualElement;
        }
        return null;
    }

    public void handleEvent(Event event) {
        int selectedIndex = this.table.getSelectionIndex();
        if (selectedIndex != -1) {
            String propertyName = this.table.getItem(selectedIndex).getText(0);
            IHelpOverrider overrider = this.getOverrider(propertyName);
            URL url = null;
            url = overrider == null ? PlatformUI.getWorkbench().getHelpSystem().resolve("net.sf.jasperreports.doc/docs/config.reference.html?cp=0_2#".concat(propertyName), false) : PlatformUI.getWorkbench().getHelpSystem().resolve(overrider.getPropertyURL(propertyName), false);
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(url.toExternalForm());
        }
    }

    public static void setTableHelp(Table table) {
        if (table != null) {
            if (overrideMap == null) {
                overrideMap = new ArrayList<IHelpOverrider>();
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.csv.column.names.", "net.sf.jasperreports.csv.column.names.{arbitrary_name}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.ejbql.query.hint.", "net.sf.jasperreports.ejbql.query.hint.{hint}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.query.executer.factory.", "net.sf.jasperreports.query.executer.factory.{language}"));
                overrideMap.add(new RegularExpressionOverrider(Arrays.asList("net\\.sf\\.jasperreports\\.compiler\\.\\p{Alnum}+", "^(?!net\\.sf\\.jasperreports\\.compiler\\.classpath).*$"), "net.sf.jasperreports.compiler.{language}"));
                overrideMap.add(new StylesOverrider());
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.chart.renderer.factory.", "net.sf.jasperreports.chart.renderer.factory.{render_type}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.markup.processor.factory.", "net.sf.jasperreports.markup.processor.factory.{markup}"));
                overrideMap.add(new RegularExpressionOverrider("net\\.sf\\.jasperreports\\.export\\.\\p{Alnum}+\\.exclude\\.origin\\.\\p{Alnum}+\\.\\p{Alnum}+", "net.sf.jasperreports.export.{format}.exclude.origin.{suffix}.{arbitrary_name}"));
                overrideMap.add(new RegularExpressionOverrider("net\\.sf\\.jasperreports\\.export\\.\\p{Alnum}+\\.exclude\\.origin\\.keep\\.first\\.\\p{Alnum}+\\.\\p{Alnum}+", "net.sf.jasperreports.export.{format}.exclude.origin.keep.first.{suffix}.{arbitrary_name}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.filter.factory.", "net.sf.jasperreports.export.filter.factory.{filter_element}"));
                overrideMap.add(new RegularExpressionOverrider("net\\.sf\\.jasperreports\\.export\\.\\p{Alnum}+\\.default\\.filter\\.factory", "net.sf.jasperreports.export.{arbitrary_name}.default.filter.factory"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.csv.column.names.", "net.sf.jasperreports.csv.column.names.{arbitrary_name}"));
                overrideMap.add(new GenericOverrider("nnet.sf.jasperreports.export.pdf.font.", "net.sf.jasperreports.export.pdf.font.{arbitrary_name}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.pdf.fontdir.", "net.sf.jasperreports.export.pdf.fontdir.{arbitrary_name}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.xls.column.names.", "net.sf.jasperreports.export.xls.column.names.{suffix}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.xls.row.outline.level.", "net.sf.jasperreports.export.xls.row.outline.level.{arbitrary_level}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.export.xls.sheet.names.", "net.sf.jasperreports.export.xls.sheet.names.{arbitrary_name}"));
                overrideMap.add(new RegularExpressionOverrider("net\\.sf\\.jasperreports\\.extension\\.\\p{Alnum}\\.\\p{Alnum}", "net.sf.jasperreports.extension.{registry_id}.{property_suffix}"));
                overrideMap.add(new GenericOverrider("net.sf.jasperreports.extension.registry.factory.", "net.sf.jasperreports.extension.registry.factory.{arbitrary_name}"));
                overrideMap.add(new RegularExpressionOverrider("net\\.sf\\.jasperreports\\.components\\.\\p{Alnum}\\.version", "net.sf.jasperreports.components.{built_in_component_name}.version"));
            }
            table.addListener(28, (Listener)new TableHelpListener(table));
        }
    }
}

