/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.editor.AMultiEditor;
import com.jaspersoft.studio.utils.CacheMap;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashSet;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ElementIconConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AComponentDesignConverter
extends ElementIconConverter
implements ComponentDesignConverter {
    protected CacheMap<JRComponentElement, Renderable> cache = new CacheMap(3000000);
    protected CacheMap<JRElement, KeyValue<String, Long>> running = new CacheMap(300000);
    protected static CacheMap<KeyValue<JasperReportsContext, String>, JRComponentElement> imgCache = new CacheMap(300000);
    protected static Renderable noImage;

    public AComponentDesignConverter(String iconLocation) {
        super(iconLocation);
    }

    public abstract String getComponentName();

    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        Renderable cacheRenderer = this.getRenderable(reportConverter, element, element.getComponent(), printImage);
        printImage.setUUID(element.getUUID());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setHeight(element.getHeight());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        printImage.setHorizontalImageAlign(HorizontalImageAlignEnum.LEFT);
        printImage.setVerticalImageAlign(VerticalImageAlignEnum.TOP);
        printImage.setRenderer(cacheRenderer);
        return printImage;
    }

    protected Renderable getRenderable(ReportConverter reportConverter, JRComponentElement element, Component cmp, JRBasePrintImage printImage) {
        Renderable cacheRenderer = null;
        OnErrorTypeEnum onErrorType = this.getOnErrorType(cmp);
        try {
            cacheRenderer = this.cache.get(element);
            String ekey = this.getEKey(element);
            if (!ekey.isEmpty()) {
                KeyValue<String, Long> last = this.running.get(element);
                Renderable r = null;
                if (cacheRenderer == null) {
                    cacheRenderer = AComponentDesignConverter.getRenderableNoImage(reportConverter.getJasperReportsContext(), onErrorType, (JRPrintImage)printImage);
                    this.cache.put(element, cacheRenderer);
                    if (last == null) {
                        r = this.doFindImage(reportConverter, element, cmp, ekey, cacheRenderer);
                    }
                }
                if (last == null || last.key == null) {
                    r = this.doFindImage(reportConverter, element, cmp, ekey, cacheRenderer);
                } else if (last != null && !((String)last.key).equals(ekey)) {
                    r = this.doFindImage(reportConverter, element, cmp, ekey, cacheRenderer);
                }
                if (r != null) {
                    cacheRenderer = r;
                }
            } else {
                this.running.remove(element);
                cacheRenderer = AComponentDesignConverter.getRenderableNoImage(reportConverter.getJasperReportsContext(), onErrorType, (JRPrintImage)printImage);
                this.cache.put(element, cacheRenderer);
            }
        }
        catch (Throwable throwable) {
            return AComponentDesignConverter.getRenderableNoImage(reportConverter.getJasperReportsContext(), onErrorType, (JRPrintImage)printImage);
        }
        return cacheRenderer;
    }

    protected Renderable doFindImage(final ReportConverter reportConverter, final JRComponentElement element, final Component cmp, final String ekey, Renderable cacheRenderer) {
        final JasperReportsConfiguration jrContext = (JasperReportsConfiguration)reportConverter.getJasperReportsContext();
        final KeyValue key = new KeyValue((Object)jrContext, (Object)ekey);
        JRComponentElement r = imgCache.get(key);
        if (r != null) {
            return this.cache.get(key);
        }
        imgCache.put((KeyValue<JasperReportsContext, String>)key, element);
        final KeyValue kv = new KeyValue(null, null);
        this.running.put((JRElement)element, (KeyValue<String, Long>)kv);
        Job job = new Job("load map"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final Renderable r = AComponentDesignConverter.this.doRenderable(reportConverter, element, cmp, ekey, jrContext, (KeyValue<String, Long>)kv);
                    imgCache.put((KeyValue<JasperReportsContext, String>)key, element);
                    AComponentDesignConverter.this.cache.put(element, r);
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).AComponentDesignConverter.this.cache.put(element, r);
                            kv.value = System.currentTimeMillis();
                            AMultiEditor.refresh((JasperReportsContext)jrContext);
                        }
                    });
                    HashSet set = new HashSet();
                    for (KeyValue k : set) {
                        imgCache.get(k);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    protected abstract Renderable doRenderable(ReportConverter var1, JRComponentElement var2, Component var3, String var4, JasperReportsConfiguration var5, KeyValue<String, Long> var6) throws JRException;

    protected abstract String getEKey(JRComponentElement var1);

    protected abstract OnErrorTypeEnum getOnErrorType(Component var1);

    protected static <T> T evaluate(JRExpression expr, JRDataset jrd, JasperReportsConfiguration jConfig, T def) {
        Object l;
        if (expr != null && (l = ExpressionUtil.cachedExpressionEvaluation(expr, jConfig, (JRDesignDataset)jrd)) != null) {
            try {
                return (T)l;
            }
            catch (Exception exception) {
                return def;
            }
        }
        return def;
    }

    protected static Renderable getRenderableNoImage(JasperReportsContext jasperReportsContext, OnErrorTypeEnum onError, JRPrintImage printImage) {
        try {
            printImage.setScaleImage(ScaleImageEnum.CLIP);
            if (noImage == null) {
                noImage = RendererUtil.getInstance((JasperReportsContext)jasperReportsContext).getNonLazyRenderable("net/sf/jasperreports/engine/images/image-16.png", onError);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return noImage;
    }
}

