/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import java.awt.Image;
import net.sf.jasperreports.chartthemes.simple.FileImageProvider;
import net.sf.jasperreports.engine.JasperReportsContext;

public class CachedImageProvider
extends FileImageProvider {
    private static final long serialVersionUID = 10200L;
    private Image image;
    private long last = -1L;

    public CachedImageProvider() {
    }

    public CachedImageProvider(String file) {
        super(file);
    }

    public CachedImageProvider(FileImageProvider p) {
        super(p.getFile());
    }

    public Image getImage(JasperReportsContext jasperReportsContext) {
        if (this.image == null && System.currentTimeMillis() - this.last > 1000L) {
            try {
                this.image = super.getImage(jasperReportsContext);
                this.last = -1L;
            }
            catch (Exception exception) {
                this.last = System.currentTimeMillis();
                return null;
            }
        }
        return this.image;
    }

    public void setFile(String file) {
        super.setFile(file);
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }
}

