/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.jasper.JSSConvertVisitor;
import com.jaspersoft.studio.jasper.JSSRenderersCache;
import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.PrintDrawVisitor;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.engine.util.UniformElementVisitor;
import net.sf.jasperreports.renderers.RenderersCache;

public class JSSDrawVisitor
extends UniformElementVisitor {
    protected JSSConvertVisitor convertVisitor;
    protected PrintDrawVisitor drawVisitor;
    protected ReportConverter reportConverter;
    private Graphics2D grx;
    private boolean ignoreFont;
    private boolean minPrintJobSize;

    public JSSDrawVisitor(ReportConverter reportConverter, Graphics2D grx) {
        this.reportConverter = reportConverter;
        this.convertVisitor = new JSSConvertVisitor(reportConverter);
        JasperReportsContext jasperReportsContext = reportConverter.getJasperReportsContext();
        JRPropertiesUtil putil = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext);
        JRReport report = reportConverter.getReport();
        this.minPrintJobSize = putil.getBooleanProperty((JRPropertiesHolder)report, "net.sf.jasperreports.export.graphics2d.min.job.size", true);
        this.ignoreFont = putil.getBooleanProperty((JRPropertiesHolder)report, "net.sf.jasperreports.awt.ignore.missing.font", false);
        JSSRenderersCache renderCache = new JSSRenderersCache(jasperReportsContext);
        this.drawVisitor = new PrintDrawVisitor(jasperReportsContext, (RenderersCache)renderCache, this.minPrintJobSize, this.ignoreFont, true, false);
        this.grx = grx;
        this.setGraphics2D(grx);
        this.drawVisitor.setClip(true);
    }

    public void refreshFontsCache() {
        JasperReportsContext jasperReportsContext = this.reportConverter.getJasperReportsContext();
        AwtTextRenderer textRenderer = new AwtTextRenderer(jasperReportsContext, this.minPrintJobSize, this.ignoreFont, true, false);
        TextDrawer textDrawer = new TextDrawer(jasperReportsContext, textRenderer);
        this.drawVisitor.setTextDrawer(textDrawer);
    }

    public void setClip(boolean clip) {
        this.drawVisitor.setClip(clip);
    }

    public void setGraphics2D(Graphics2D grx) {
        this.grx = grx;
        this.drawVisitor.setGraphics2D(grx);
    }

    public Graphics2D getGraphics2d() {
        return this.grx;
    }

    public ReportConverter getReportConverter() {
        return this.reportConverter;
    }

    public JSSConvertVisitor getConvertVisitor() {
        return this.convertVisitor;
    }

    public PrintDrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    public void visitBreak(JRBreak breakElement) {
    }

    protected void visitElement(JRElement element) {
        try {
            JRPrintElement printElement = this.convertVisitor.getVisitPrintElement((JRVisitable)element);
            printElement.accept((PrintElementVisitor)this.drawVisitor, (Object)JSSDrawVisitor.elementOffset(element));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Offset elementOffset(JRElement element) {
        return new Offset(-element.getX(), -element.getY());
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
    }
}

